/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.mail.smime.handlers;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEStreamingProcessor;

public class PKCS7ContentHandler
implements DataContentHandler {
    private final ActivationDataFlavor _adf;
    private final ActivationDataFlavor[] _dfs;

    PKCS7ContentHandler(ActivationDataFlavor adf, ActivationDataFlavor[] dfs) {
        this._adf = adf;
        this._dfs = dfs;
    }

    public Object getContent(DataSource ds) throws IOException {
        return ds.getInputStream();
    }

    public Object getTransferData(ActivationDataFlavor df, DataSource ds) throws IOException {
        if (this._adf.equals(df)) {
            return this.getContent(ds);
        }
        return null;
    }

    public ActivationDataFlavor[] getTransferDataFlavors() {
        return this._dfs;
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (obj instanceof MimeBodyPart) {
            try {
                ((MimeBodyPart)obj).writeTo(os);
            }
            catch (MessagingException ex) {
                throw new IOException(ex.getMessage());
            }
        } else if (obj instanceof byte[]) {
            os.write((byte[])obj);
        } else if (obj instanceof InputStream) {
            int b;
            InputStream in = (InputStream)obj;
            if (!(in instanceof BufferedInputStream)) {
                in = new BufferedInputStream(in);
            }
            while ((b = in.read()) >= 0) {
                os.write(b);
            }
            in.close();
        } else if (obj instanceof SMIMEStreamingProcessor) {
            SMIMEStreamingProcessor processor = (SMIMEStreamingProcessor)obj;
            processor.write(os);
        } else {
            throw new IOException("unknown object in writeTo " + obj);
        }
    }
}

