/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicSubkeyPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SignatureSubpacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKeyPair;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;

public class PGPKeyRingGenerator {
    List keys = new ArrayList();
    private PBESecretKeyEncryptor keyEncryptor;
    private PGPDigestCalculator checksumCalculator;
    private PGPKeyPair masterKey;
    private PGPSignatureSubpacketVector hashedPcks;
    private PGPSignatureSubpacketVector unhashedPcks;
    private PGPContentSignerBuilder keySignerBuilder;

    public PGPKeyRingGenerator(int certificationLevel, PGPKeyPair masterKey, String id, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder keySignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.masterKey = masterKey;
        this.keyEncryptor = keyEncryptor;
        this.checksumCalculator = checksumCalculator;
        this.keySignerBuilder = keySignerBuilder;
        this.hashedPcks = hashedPcks;
        this.unhashedPcks = unhashedPcks;
        this.keys.add(new PGPSecretKey(certificationLevel, masterKey, id, checksumCalculator, hashedPcks, unhashedPcks, keySignerBuilder, keyEncryptor));
    }

    public PGPKeyRingGenerator(PGPKeyPair masterKey, PGPDigestCalculator checksumCalculator, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder keySignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        PGPSignatureGenerator sigGen;
        this.masterKey = masterKey;
        this.keyEncryptor = keyEncryptor;
        this.checksumCalculator = checksumCalculator;
        this.keySignerBuilder = keySignerBuilder;
        this.hashedPcks = hashedPcks;
        this.unhashedPcks = unhashedPcks;
        try {
            sigGen = new PGPSignatureGenerator(keySignerBuilder);
        }
        catch (Exception e) {
            throw new PGPException("creating signature generator: " + e, e);
        }
        sigGen.init(31, masterKey.getPrivateKey());
        sigGen.setHashedSubpackets(hashedPcks);
        sigGen.setUnhashedSubpackets(unhashedPcks);
        PGPSecretKey secretKey = new PGPSecretKey(masterKey.getPrivateKey(), masterKey.getPublicKey(), checksumCalculator, true, keyEncryptor);
        PGPPublicKey publicKey = secretKey.getPublicKey();
        try {
            PGPSignature certification = sigGen.generateCertification(masterKey.getPublicKey());
            publicKey = PGPPublicKey.addCertification(publicKey, certification);
        }
        catch (Exception e) {
            throw new PGPException("exception doing direct-key signature: " + e, e);
        }
        secretKey = PGPSecretKey.replacePublicKey(secretKey, publicKey);
        this.keys.add(secretKey);
    }

    public PGPKeyRingGenerator(PGPSecretKeyRing originalSecretRing, PBESecretKeyDecryptor secretKeyDecryptor, PGPDigestCalculator checksumCalculator, PGPContentSignerBuilder keySignerBuilder, PBESecretKeyEncryptor keyEncryptor) throws PGPException {
        this.masterKey = new PGPKeyPair(originalSecretRing.getPublicKey(), originalSecretRing.getSecretKey().extractPrivateKey(secretKeyDecryptor));
        this.keyEncryptor = keyEncryptor;
        this.checksumCalculator = checksumCalculator;
        this.keySignerBuilder = keySignerBuilder;
        PGPSignature certSig = originalSecretRing.getPublicKey().getSignatures().next();
        ArrayList<SignatureSubpacket> hashedVec = new ArrayList<SignatureSubpacket>();
        PGPSignatureSubpacketVector existing = certSig.getHashedSubPackets();
        for (int i = 0; i != existing.size(); ++i) {
            if (existing.packets[i].getType() == 2) continue;
            hashedVec.add(existing.packets[i]);
        }
        this.hashedPcks = new PGPSignatureSubpacketVector(hashedVec.toArray(new SignatureSubpacket[hashedVec.size()]));
        this.unhashedPcks = certSig.getUnhashedSubPackets();
        this.keys.addAll(originalSecretRing.keys);
    }

    public void addSubKey(PGPKeyPair keyPair) throws PGPException {
        this.addSubKey(keyPair, this.hashedPcks, this.unhashedPcks);
    }

    public void addSubKey(PGPKeyPair keyPair, PGPContentSignerBuilder bindingSignerBldr) throws PGPException {
        this.addSubKey(keyPair, this.hashedPcks, this.unhashedPcks, bindingSignerBldr);
    }

    public void addSubKey(PGPKeyPair keyPair, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks) throws PGPException {
        this.addSubKey(keyPair, hashedPcks, unhashedPcks, null);
    }

    public void addSubKey(PGPKeyPair keyPair, PGPSignatureSubpacketVector hashedPcks, PGPSignatureSubpacketVector unhashedPcks, PGPContentSignerBuilder bindingSignerBldr) throws PGPException {
        try {
            PGPSignatureGenerator sGen = new PGPSignatureGenerator(this.keySignerBuilder);
            sGen.init(24, this.masterKey.getPrivateKey());
            if (bindingSignerBldr != null) {
                PGPSignatureGenerator pGen = new PGPSignatureGenerator(bindingSignerBldr);
                pGen.init(25, keyPair.getPrivateKey());
                PGPSignatureSubpacketGenerator spGen = new PGPSignatureSubpacketGenerator(hashedPcks);
                spGen.addEmbeddedSignature(false, pGen.generateCertification(this.masterKey.getPublicKey(), keyPair.getPublicKey()));
                sGen.setHashedSubpackets(spGen.generate());
            } else {
                sGen.setHashedSubpackets(hashedPcks);
            }
            sGen.setUnhashedSubpackets(unhashedPcks);
            ArrayList<PGPSignature> subSigs = new ArrayList<PGPSignature>();
            subSigs.add(sGen.generateCertification(this.masterKey.getPublicKey(), keyPair.getPublicKey()));
            PGPPublicKey pubSubKey = new PGPPublicKey(keyPair.getPublicKey(), null, subSigs);
            pubSubKey.publicPk = new PublicSubkeyPacket(pubSubKey.getAlgorithm(), pubSubKey.getCreationTime(), pubSubKey.publicPk.getKey());
            this.keys.add(new PGPSecretKey(keyPair.getPrivateKey(), pubSubKey, this.checksumCalculator, this.keyEncryptor));
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("exception adding subkey: ", e);
        }
    }

    public PGPSecretKeyRing generateSecretKeyRing() {
        return new PGPSecretKeyRing(this.keys);
    }

    public PGPPublicKeyRing generatePublicKeyRing() {
        Iterator it = this.keys.iterator();
        ArrayList<PGPPublicKey> pubKeys = new ArrayList<PGPPublicKey>();
        pubKeys.add(((PGPSecretKey)it.next()).getPublicKey());
        while (it.hasNext()) {
            pubKeys.add(((PGPSecretKey)it.next()).getPublicKey());
        }
        return new PGPPublicKeyRing(pubKeys);
    }
}

