/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.HKDFParameters;
import net.savignano.thirdparty.org.bouncycastle.math.ec.ECPoint;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;

class RFC6637KDFCalculator {
    private static final byte[] ANONYMOUS_SENDER = Hex.decode("416E6F6E796D6F75732053656E64657220202020");
    private final PGPDigestCalculator digCalc;
    private final int keyAlgorithm;

    public RFC6637KDFCalculator(PGPDigestCalculator digCalc, int keyAlgorithm) {
        this.digCalc = digCalc;
        this.keyAlgorithm = keyAlgorithm;
    }

    public byte[] createKey(ECPoint s, byte[] userKeyingMaterial) throws PGPException {
        return this.createKey(s.getAffineXCoord().getEncoded(), userKeyingMaterial);
    }

    public byte[] createKey(byte[] secret, byte[] userKeyingMaterial) throws PGPException {
        try {
            return RFC6637KDFCalculator.KDF(this.digCalc, secret, RFC6637KDFCalculator.getKeyLen(this.keyAlgorithm), userKeyingMaterial);
        }
        catch (IOException e) {
            throw new PGPException("Exception performing KDF: " + e.getMessage(), e);
        }
    }

    public static byte[] createKey(int algorithm, int keyAlgorithm, byte[] prepend, String info) throws PGPException {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator(BcImplProvider.createDigest(algorithm));
        hkdf.init(new HKDFParameters(prepend, null, Strings.toByteArray(info)));
        byte[] key = new byte[RFC6637KDFCalculator.getKeyLen(keyAlgorithm)];
        hkdf.generateBytes(key, 0, key.length);
        return key;
    }

    private static byte[] KDF(PGPDigestCalculator digCalc, byte[] ZB, int keyLen, byte[] param) throws IOException {
        OutputStream dOut = digCalc.getOutputStream();
        dOut.write(0);
        dOut.write(0);
        dOut.write(0);
        dOut.write(1);
        dOut.write(ZB);
        dOut.write(param);
        byte[] digest = digCalc.getDigest();
        byte[] key = new byte[keyLen];
        System.arraycopy(digest, 0, key, 0, key.length);
        return key;
    }

    private static int getKeyLen(int algID) throws PGPException {
        switch (algID) {
            case 7: 
            case 11: {
                return 16;
            }
            case 8: 
            case 12: {
                return 24;
            }
            case 9: 
            case 13: {
                return 32;
            }
        }
        throw new PGPException("unknown symmetric algorithm ID: " + algID);
    }
}

