/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openssl.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.EncryptionScheme;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PBEParameter;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PBES2Parameters;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PBKDF2Params;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.crypto.CharToByteConverter;
import net.savignano.thirdparty.org.bouncycastle.jcajce.PBKDF1KeyWithParameters;
import net.savignano.thirdparty.org.bouncycastle.jcajce.PKCS12KeyWithParameters;
import net.savignano.thirdparty.org.bouncycastle.jcajce.io.CipherInputStream;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMException;
import net.savignano.thirdparty.org.bouncycastle.openssl.jcajce.PEMUtilities;
import net.savignano.thirdparty.org.bouncycastle.operator.InputDecryptor;
import net.savignano.thirdparty.org.bouncycastle.operator.InputDecryptorProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class JceOpenSSLPKCS8DecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public InputDecryptorProvider build(final char[] password) throws OperatorCreationException {
        return new InputDecryptorProvider(){

            @Override
            public InputDecryptor get(final AlgorithmIdentifier algorithm) throws OperatorCreationException {
                try {
                    Cipher cipher;
                    if (PEMUtilities.isPKCS5Scheme2(algorithm.getAlgorithm())) {
                        PBES2Parameters params = PBES2Parameters.getInstance(algorithm.getParameters());
                        KeyDerivationFunc func = params.getKeyDerivationFunc();
                        EncryptionScheme scheme = params.getEncryptionScheme();
                        PBKDF2Params defParams = (PBKDF2Params)func.getParameters();
                        int iterationCount = defParams.getIterationCount().intValue();
                        byte[] salt = defParams.getSalt();
                        String oid = scheme.getAlgorithm().getId();
                        SecretKey key = PEMUtilities.isHmacSHA1(defParams.getPrf()) ? PEMUtilities.generateSecretKeyForPKCS5Scheme2(JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper, oid, password, salt, iterationCount) : PEMUtilities.generateSecretKeyForPKCS5Scheme2(JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper, oid, password, salt, iterationCount, defParams.getPrf());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(PEMUtilities.getCipherName(scheme.getAlgorithm()));
                        AlgorithmParameters algParams = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createAlgorithmParameters(oid);
                        algParams.init(scheme.getParameters().toASN1Primitive().getEncoded());
                        cipher.init(2, (Key)key, algParams);
                    } else if (PEMUtilities.isPKCS12(algorithm.getAlgorithm())) {
                        PKCS12PBEParams params = PKCS12PBEParams.getInstance(algorithm.getParameters());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(PEMUtilities.getCipherName(algorithm.getAlgorithm()));
                        cipher.init(2, new PKCS12KeyWithParameters(password, params.getIV(), params.getIterations().intValue()));
                    } else if (PEMUtilities.isPKCS5Scheme1(algorithm.getAlgorithm())) {
                        PBEParameter params = PBEParameter.getInstance(algorithm.getParameters());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(PEMUtilities.getCipherName(algorithm.getAlgorithm()));
                        cipher.init(2, new PBKDF1KeyWithParameters(password, new CharToByteConverter(){

                            @Override
                            public String getType() {
                                return "ASCII";
                            }

                            @Override
                            public byte[] convert(char[] password) {
                                return Strings.toByteArray(password);
                            }
                        }, params.getSalt(), params.getIterationCount().intValue()));
                    } else {
                        throw new PEMException("Unknown algorithm: " + algorithm.getAlgorithm());
                    }
                    return new InputDecryptor(){

                        @Override
                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return algorithm;
                        }

                        @Override
                        public InputStream getInputStream(InputStream encIn) {
                            return new CipherInputStream(encIn, cipher);
                        }
                    };
                }
                catch (IOException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
                catch (GeneralSecurityException e) {
                    throw new OperatorCreationException(algorithm.getAlgorithm() + " not available: " + e.getMessage(), e);
                }
            }
        };
    }
}

