/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.slf4j.Logger;

public class PgpValidationKeyStoreLoader
extends AKeyLoader<PgpValidationKey, Long> {
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_ID = 201;
    public static final int INFO_KEY_FOUND = 202;
    public static final int INFO_KEY_NOT_FOUND = 203;
    private final PGPPublicKeyRingCollection pubKeyRings;
    private final PGPSecretKeyRingCollection secKeyRings;

    public PgpValidationKeyStoreLoader(PGPPublicKeyRingCollection keyRings) {
        this.pubKeyRings = keyRings;
        this.secKeyRings = null;
    }

    public PgpValidationKeyStoreLoader(PGPSecretKeyRingCollection keyRings) {
        this.secKeyRings = keyRings;
        this.pubKeyRings = null;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpValidationKey loadInternalKey(Long forId) throws Exception {
        PGPPublicKey publicKey;
        if (this.pubKeyRings == null && this.secKeyRings == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (forId == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        Logger log = this.getLog();
        log.info("Looking up PGP public key for ID {} in key rings.", (Object)forId);
        PGPPublicKey pGPPublicKey = publicKey = this.pubKeyRings != null ? this.getKeyFromPublic(forId) : this.getKeyFromSecret(forId);
        if (publicKey == null) {
            log.info("Found no PGP public key for ID {} in key store.", (Object)forId);
            this.getInfoDataManager().send(new InfoData(203, forId));
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.info("Found valid PGP public key ring for ID {} in key store.", (Object)forId);
        log.trace("Found PGP public key: {}", (Object)publicKey);
        this.getInfoDataManager().send(new InfoData(202, forId));
        PgpValidationKey key = new PgpValidationKey(publicKey);
        key.setKeySource(this.getKeySource());
        return key;
    }

    private PGPPublicKey getKeyFromPublic(Long forId) {
        return this.pubKeyRings.getPublicKey(forId);
    }

    private PGPPublicKey getKeyFromSecret(Long forId) {
        PGPSecretKey secretKey = this.secKeyRings.getSecretKey(forId);
        return secretKey != null ? secretKey.getPublicKey() : null;
    }

    @Override
    protected PgpValidationKey getValidityKey(EKeyValidity validity) {
        return new PgpValidationKey(validity, this.getKeySource());
    }

    public String toString() {
        return "PgpValidationKeyStoreLoader [keyRings=" + String.valueOf(this.pubKeyRings != null ? this.pubKeyRings : this.secKeyRings) + "]";
    }
}

