/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Stream;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.util.SmimeUtil;

public abstract class ASmimeKeyLoader<T extends ACryptographyKey<?>, U>
extends AKeyLoader<T, U> {
    private boolean ignoreCriticalExtension;

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    protected T findBest(Stream<T> keys, Function<T, X509Certificate> certGetter) {
        Comparator comparator = (a, b) -> {
            int compared = a.compareTo((ICryptographyKey<?>)b);
            if (compared != 0) {
                return compared;
            }
            return a.isValid() ? SmimeUtil.getCertificateComparator().compare((X509Certificate)certGetter.apply(a), (X509Certificate)certGetter.apply(b)) : 0;
        };
        Optional<T> key = keys.reduce(BinaryOperator.minBy(comparator));
        if (key.isPresent()) {
            return (T)((ACryptographyKey)key.get());
        }
        return (T)((ACryptographyKey)this.getValidityKey(EKeyValidity.NOT_FOUND));
    }

    protected boolean isCritExtensionSatisfied(X509Certificate cert) {
        return this.isIgnoreCriticalExtension() || SmimeUtil.isCertCriticalExtensionSatisfied(cert);
    }

    public boolean isIgnoreCriticalExtension() {
        return this.ignoreCriticalExtension;
    }

    public void setIgnoreCriticalExtension(boolean ignoreCriticalExtension) {
        this.ignoreCriticalExtension = ignoreCriticalExtension;
    }
}

