/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.decrypt;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import net.savignano.cryptography.mail.BaseMailCryptography;
import net.savignano.cryptography.mail.IKeyProvider;
import net.savignano.cryptography.mail.decrypt.IMailDecryptor;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;

public abstract class AMailDecryptor<T extends ISecretCryptographyKey<?>, U>
extends BaseMailCryptography
implements IMailDecryptor<T, U> {
    private static final String MAIL_HEADER_DECRYPTED_PATTERN = "{3} by {0}";
    private static final String MAIL_HEADER_DECRYPTED_DEBUG_PATTERN = "{3} by {0} {1} at {2}";

    protected AMailDecryptor(Session session, ECryptographyType cryptography) {
        super(session, cryptography);
    }

    @Override
    public void decryptMessage(MimeMessage msg, T key) throws IOException, MessagingException {
        if (key == null) {
            throw new MessagingException("Cannot decrypt message because no key was provided.");
        }
        if (!key.isValid()) {
            throw new MessagingException("Cannot decrypt message because of key having validity: " + (Object)((Object)key.getKeyValidity()));
        }
        this.decryptMessage(msg, this.toProvider(key));
    }

    @Override
    public void decryptMessage(MimeMessage msg, IKeyProvider<U, T> provider) throws IOException, MessagingException {
        if (msg == null) {
            return;
        }
        if (provider == null) {
            throw new MessagingException("Cannot decrypt message because no provider was given.");
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId((Message)msg);
        log.info("Decrypting message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        this.traceMessage(msg, "Original email:\n{}");
        try {
            this.decrypt(msg, provider);
        }
        catch (Exception e) {
            String errMsg = "Could not decrypt message with msg ID " + msgId + ". Error message: " + e.getMessage();
            throw new MessagingException(errMsg, e);
        }
        log.info("Successfully decrypted message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        this.traceMessage(msg, "Final email:\n{}");
    }

    protected abstract void decrypt(MimeMessage var1, IKeyProvider<U, T> var2) throws Exception;

    protected abstract IKeyProvider<U, T> toProvider(T var1);

    protected void includeDecryptionHeader(MimeMessage msg) throws MessagingException {
        String headerPattern = this.isVerboseHeader() ? MAIL_HEADER_DECRYPTED_DEBUG_PATTERN : MAIL_HEADER_DECRYPTED_PATTERN;
        this.includeCryptographyHeader(msg, "X-Decrypted", headerPattern, new Object[]{this.getCryptography()});
    }

    protected boolean isVerboseHeader() {
        return this.getLog().isDebugEnabled();
    }
}

