/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.properties;

import net.savignano.cryptography.Constants;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASnotifyUserProperties
implements ISnotifyUserProperties {
    private static final Logger log = LoggerFactory.getLogger(ASnotifyUserProperties.class);
    private static final String SETTINGS_STRING_EXISTS = ".exists";
    private static final String SETTINGS_STRING_PAGES = ".pages";
    private static final String SETTINGS_STRING_PAGE = ".page.";

    protected abstract String get(String var1, IUser<?> var2) throws Exception;

    protected abstract void set(String var1, String var2, IUser<?> var3) throws Exception;

    protected abstract void remove(String var1, IUser<?> var2) throws Exception;

    private String getCheckedString(String key, IUser<?> user) {
        try {
            String value = StringUtils.stripToNull((String)this.get(key, user));
            log.trace("User ({}) property \"{}\" is: {}", new Object[]{user, key, value});
            return value;
        }
        catch (ClassCastException e) {
            log.debug("ClassCastException getting user (" + String.valueOf(user) + ") property \"" + key + "\".", (Throwable)e);
            this.setCheckedString(key, null, user);
        }
        catch (Exception e) {
            log.error("Could not get user (" + String.valueOf(user) + ") property \"" + key + "\".", (Throwable)e);
        }
        return null;
    }

    private void setCheckedString(String key, String value, IUser<?> user) {
        if (StringUtils.stripToNull((String)value) == null) {
            log.trace("Removing user ({}) property \"{}\".", user, (Object)key);
            try {
                this.remove(key, user);
            }
            catch (Exception e) {
                log.error("Could not remove user (" + String.valueOf(user) + ") property \"" + key + "\".", (Throwable)e);
            }
        } else {
            log.trace("Setting user ({}) property \"{}\" to: {}", new Object[]{user, key, value});
            try {
                this.set(key, value, user);
            }
            catch (Exception e) {
                log.error("Could not set user (" + String.valueOf(user) + ") property \"" + key + "\" to \"" + value + "\".", (Throwable)e);
            }
        }
    }

    public final String getAsString(EProperty prop, IUser<?> user) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return null;
        }
        return this.getString(prop.getKey(), user);
    }

    public final void setAsString(EProperty prop, String value, IUser<?> user) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return;
        }
        this.setString(prop.getKey(), value, user);
    }

    @Override
    public boolean hasKey(EProperty prop, IUser<?> user) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return false;
        }
        if (prop.getPropType() != EProperty.EPropertyType.USER) {
            log.warn("Given property {} is of type {}, but {} is expected. Probably wrong property given.", new Object[]{prop.name(), prop.getPropType(), EProperty.EPropertyType.USER});
        }
        return this.hasKey(prop, user);
    }

    protected boolean hasKey(String key, IUser<?> user) {
        if (this.getString(key, user) != null) {
            return true;
        }
        Boolean exists = this.getBoolean(key + SETTINGS_STRING_EXISTS, user);
        return exists != null && exists != false;
    }

    @Override
    public final String getString(EProperty prop, IUser<?> user) {
        if (this.checkType(String.class, prop)) {
            String value = this.getString(prop.getKey(), user);
            return value != null ? value : (String)prop.getDefaultValue();
        }
        return null;
    }

    protected String getString(String key, IUser<?> user) {
        return this.getCheckedString(key, user);
    }

    @Override
    public final String getUnlimitedString(EProperty prop, IUser<?> user) {
        if (this.checkType(String.class, prop)) {
            String value = this.getUnlimitedString(prop.getKey(), user);
            return value != null ? value : (String)prop.getDefaultValue();
        }
        return null;
    }

    protected String getUnlimitedString(String key, IUser<?> user) {
        Boolean exists = this.getBoolean(key + SETTINGS_STRING_EXISTS, user);
        if (exists == null || !exists.booleanValue()) {
            return null;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, user);
        if (pagesValue == null) {
            return null;
        }
        int pages = pagesValue.intValue();
        StringBuilder builder = new StringBuilder(255 * pages);
        for (int i = 0; i < pages; ++i) {
            String page = this.getString(key + SETTINGS_STRING_PAGE + i, user);
            builder.append(page);
        }
        return StringUtils.stripToNull((String)builder.toString());
    }

    @Override
    public final boolean getBoolean(EProperty prop, IUser<?> user) {
        if (this.checkType(Boolean.class, prop)) {
            Boolean value = this.getBoolean(prop.getKey(), user);
            return value != null ? value : (Boolean)prop.getDefaultValue();
        }
        return false;
    }

    @Override
    public final boolean getBoolean(EProperty prop, boolean defaultValue, IUser<?> user) {
        if (this.checkType(Boolean.class, prop)) {
            Boolean value = this.getBoolean(prop.getKey(), user);
            return value != null ? value : defaultValue;
        }
        return false;
    }

    protected Boolean getBoolean(String key, IUser<?> user) {
        String value = this.getString(key, user);
        if (value == null) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public final Long getLong(EProperty prop, IUser<?> user) {
        if (this.checkType(Long.class, prop)) {
            Long value = this.getLong(prop.getKey(), user);
            return value != null ? value : (Long)prop.getDefaultValue();
        }
        return null;
    }

    protected Long getLong(String key, IUser<?> user) {
        String value = this.getString(key, user);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                log.error("Value " + value + " stored in user property " + key + " for user " + String.valueOf(user) + " is not a Long.", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public final <T extends Enum<T>> T getEnum(EProperty prop, Class<T> clazz, IUser<?> user) {
        if (this.checkType(clazz, prop)) {
            T value = this.getEnum(prop.getKey(), clazz, user);
            return (T)(value != null ? value : (Enum)prop.getDefaultValue());
        }
        return null;
    }

    protected <T extends Enum<T>> T getEnum(String key, Class<T> clazz, IUser<?> user) {
        String value = this.getString(key, user);
        if (value != null) {
            try {
                return Enum.valueOf(clazz, value);
            }
            catch (IllegalArgumentException e) {
                log.error("Value " + value + " stored in application property " + key + " for user " + String.valueOf(user) + " is not a valid value for enum " + clazz.getSimpleName() + ".", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public final byte[] getBytes(EProperty prop, IUser<?> user) {
        if (this.checkType(byte[].class, prop)) {
            byte[] value = this.getBytes(prop.getKey(), user);
            return value != null ? value : (byte[])prop.getDefaultValue();
        }
        return null;
    }

    protected byte[] getBytes(String key, IUser<?> user) {
        String base64Value = this.getUnlimitedString(key, user);
        if (base64Value != null) {
            return Base64.decodeBase64((byte[])base64Value.getBytes(Constants.UTF8_CHARSET));
        }
        return null;
    }

    @Override
    public final void setString(EProperty prop, String value, IUser<?> user) {
        if (this.checkType(String.class, prop)) {
            this.setString(prop.getKey(), value, user);
        }
    }

    protected void setString(String key, String value, IUser<?> user) {
        this.setCheckedString(key, value, user);
    }

    @Override
    public final void setUnlimitedString(EProperty prop, String value, IUser<?> user) {
        if (this.checkType(String.class, prop)) {
            this.setUnlimitedString(prop.getKey(), value, user);
        }
    }

    protected void setUnlimitedString(String key, String value, IUser<?> user) {
        this.removeUnlimitedString(key, user);
        if (value != null) {
            int pages = value.length() / 255 + (value.length() % 255 == 0 ? 0 : 1);
            if (pages > 0) {
                for (int i = 0; i < pages - 1; ++i) {
                    this.setString(key + SETTINGS_STRING_PAGE + i, value.substring(i * 255, (i + 1) * 255), user);
                }
                this.setString(key + SETTINGS_STRING_PAGE + (pages - 1), value.substring((pages - 1) * 255), user);
            }
            this.setLong(key + SETTINGS_STRING_PAGES, Long.valueOf(pages), user);
            this.setBoolean(key + SETTINGS_STRING_EXISTS, true, user);
        }
    }

    private void removeUnlimitedString(String key, IUser<?> user) {
        Boolean exists = this.getBoolean(key + SETTINGS_STRING_EXISTS, user);
        if (exists == null || !exists.booleanValue()) {
            return;
        }
        Long pagesValue = this.getLong(key + SETTINGS_STRING_PAGES, user);
        if (pagesValue == null) {
            return;
        }
        this.setString(key + SETTINGS_STRING_EXISTS, null, user);
        this.setLong(key + SETTINGS_STRING_PAGES, null, user);
        int pages = pagesValue.intValue();
        for (int i = 0; i < pages; ++i) {
            this.setString(key + SETTINGS_STRING_PAGE + i, null, user);
        }
    }

    @Override
    public final void setBoolean(EProperty prop, boolean value, IUser<?> user) {
        if (this.checkType(Boolean.class, prop)) {
            this.setBoolean(prop.getKey(), value, user);
        }
    }

    protected void setBoolean(String key, boolean value, IUser<?> user) {
        this.setString(key, String.valueOf(value), user);
    }

    @Override
    public final void setLong(EProperty prop, Long value, IUser<?> user) {
        if (this.checkType(Long.class, prop)) {
            this.setLong(prop.getKey(), value, user);
        }
    }

    protected void setLong(String key, Long value, IUser<?> user) {
        this.setString(key, value == null ? null : value.toString(), user);
    }

    @Override
    public final void setEnum(EProperty prop, Enum<?> value, IUser<?> user) {
        if (value == null) {
            if (prop == null) {
                log.error("Given property was null.", (Throwable)new NullPointerException());
            } else if (!prop.getType().isEnum()) {
                log.error("Property {} is not an enum.", (Object)prop.name());
            } else {
                this.setEnum(prop.getKey(), null, user);
            }
        } else if (this.checkType(value.getClass(), prop)) {
            this.setEnum(prop.getKey(), value, user);
        }
    }

    protected void setEnum(String key, Enum<?> value, IUser<?> user) {
        this.setString(key, value == null ? null : value.name(), user);
    }

    @Override
    public final void setBytes(EProperty prop, byte[] value, IUser<?> user) {
        if (this.checkType(byte[].class, prop)) {
            this.setBytes(prop.getKey(), value, user);
        }
    }

    protected void setBytes(String key, byte[] value, IUser<?> user) {
        String encoded = value == null ? null : new String(Base64.encodeBase64((byte[])value), Constants.UTF8_CHARSET);
        this.setUnlimitedString(key, encoded, user);
    }

    private boolean checkType(Class<?> exptected, EProperty actual) {
        if (exptected == null) {
            log.error("Expected class was null.", (Throwable)new NullPointerException());
            return false;
        }
        if (actual == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return false;
        }
        if (actual.getPropType() != EProperty.EPropertyType.USER) {
            log.warn("Given property {} is of type {}, but {} is expected. Probably wrong property given.", new Object[]{actual.name(), actual.getPropType(), EProperty.EPropertyType.USER});
        }
        if (exptected == actual.getType()) {
            return true;
        }
        log.error("Property {} is not of type: {}", (Object)actual.name(), (Object)exptected.getSimpleName());
        return false;
    }
}

