/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.templates.handler.impl.wrapper;

import jakarta.servlet.http.HttpServletRequest;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.templates.handler.ICheckBoxHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.AAppPropValueHandler;

public class BooleanInputToStringWrapperHandler
extends AAppPropValueHandler<Boolean>
implements ICheckBoxHandler {
    private final String falseValue;
    private final String trueValue;

    public BooleanInputToStringWrapperHandler(String id, ISnotifyAppProperties appProps, EProperty prop, String falseValue, String trueValue) {
        super(id, appProps, prop);
        this.falseValue = falseValue;
        this.trueValue = trueValue;
        if (falseValue == null) {
            throw new IllegalArgumentException("False value must not be null.");
        }
        if (trueValue == null) {
            throw new IllegalArgumentException("True value must not be null.");
        }
        if (!String.class.equals(prop.getType())) {
            throw new IllegalArgumentException("Only a 'Boolean' property is allowed.");
        }
    }

    @Override
    public void read() {
        String string = this.getAppProps().getString(this.getProp());
        if (this.falseValue.equalsIgnoreCase(string)) {
            this.setValue(false);
        } else if (this.trueValue.equalsIgnoreCase(string)) {
            this.setValue(true);
        } else {
            this.setValue(null);
        }
    }

    @Override
    public void store() {
        if (this.getValue() != null) {
            this.getAppProps().setString(this.getProp(), (Boolean)this.getValue() != false ? this.trueValue : this.falseValue);
        } else {
            this.getAppProps().setString(this.getProp(), null);
        }
    }

    @Override
    public void receive(HttpServletRequest request) {
        this.setValue(Boolean.parseBoolean(request.getParameter(this.getId())));
    }

    @Override
    public boolean isSelected() {
        return this.getValue() != null && (Boolean)this.getValue() != false;
    }

    public String asString() {
        if (this.getValue() == null) {
            return null;
        }
        return (Boolean)this.getValue() != false ? this.trueValue : this.falseValue;
    }
}

