/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.common;

import com.atlassian.sal.api.message.I18nResolver;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;

public class SnotifyI18n
implements ISnotifyI18n {
    private final I18nResolver i18n;
    private final Locale locale;

    public SnotifyI18n(I18nResolver i18n, Locale locale) {
        this.i18n = i18n;
        this.locale = locale;
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null.");
        }
    }

    @Override
    public String getText(String key) {
        return this.i18n.getText(this.locale, key);
    }

    @Override
    public String getText(String key, Object value) {
        String rawText = this.i18n.getRawText(this.locale, key);
        return MessageFormat.format(rawText, value);
    }

    @Override
    public String getText(String key, Object value1, Object value2) {
        String rawText = this.i18n.getRawText(this.locale, key);
        return MessageFormat.format(rawText, value1, value2);
    }

    @Override
    public String getText(String key, Object ... values) {
        String rawText = this.i18n.getRawText(this.locale, key);
        return MessageFormat.format(rawText, values);
    }

    @Override
    public String formatDate(LocalDate date, FormatStyle style) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(style).withLocale(this.locale);
        return formatter.format(date);
    }

    @Override
    public String formatDateTime(LocalDateTime dateTime, FormatStyle style) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(style).withLocale(this.locale);
        return formatter.format(dateTime);
    }

    @Override
    public String formatTime(LocalTime time, FormatStyle style) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(style).withLocale(this.locale);
        return formatter.format(time);
    }
}

