/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.savignano.cryptography.version.NormalizedVersion;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.gui.templates.IAdminTemplate;
import net.savignano.snotify.bitbucket.gui.servlet.SnotifyServlet;
import org.springframework.beans.factory.annotation.Autowired;

public class AdminSettingsServlet
extends SnotifyServlet
implements IAdminTemplate {
    private static final long serialVersionUID = 5110928046349591724L;
    @ComponentImport
    private PermissionService permissionService;
    @ComponentImport
    private WebSudoManager webSudoManager;

    public AdminSettingsServlet(String templateFolder) {
        super(templateFolder);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.webSudoProceed(() -> super.doGet(req, resp), req, resp);
    }

    protected void webSudoProceed(WebSudoRunnable code, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            this.webSudo(code, req, resp);
        }
        catch (WebSudoSessionException e) {
            this.webSudoManager.enforceWebSudoProtection(req, resp);
        }
    }

    protected void webSudoForbidden(WebSudoRunnable code, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        try {
            this.webSudo(code, req, resp);
        }
        catch (WebSudoSessionException e) {
            resp.sendError(403);
        }
    }

    private void webSudo(WebSudoRunnable code, HttpServletRequest req, HttpServletResponse resp) throws WebSudoSessionException, IOException, ServletException {
        this.webSudoManager.willExecuteWebSudoRequest(req);
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        code.run();
    }

    @Override
    protected void redirectLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String redirect = resp.encodeRedirectURL(req.getContextPath() + "/login?next=" + req.getServletPath() + "&permission=admin");
        resp.sendRedirect(redirect);
    }

    public boolean hasAdminRights() {
        return this.permissionService.hasGlobalPermission(Permission.ADMIN);
    }

    @Override
    public String getGetStartedLink() {
        String baseUrl = this.getApplicationPropertiesService().getBaseUrl().toString();
        return baseUrl + "/plugins/servlet/snotify/installation-guide";
    }

    @Override
    public boolean isMailerLibPresent() {
        return this.getMailerVersion() != null;
    }

    @Override
    public boolean isVersionMatch() {
        if (!this.getAppProps().getBoolean(EProperty.DEV_MODE)) {
            return IAdminTemplate.super.isVersionMatch();
        }
        NormalizedVersion guiVersion = new NormalizedVersion(this.getGuiVersion());
        NormalizedVersion mailerVersion = new NormalizedVersion(this.getMailerVersion());
        return guiVersion.equals(mailerVersion);
    }

    @Override
    public boolean isMailServerPresent() {
        return this.getApplicationPropertiesService().getMailHostConfiguration() != null;
    }

    @Override
    public String getGuiVersion() {
        return this.getAppProps().getString(EProperty.GUI_VERSION);
    }

    @Override
    public String getMailerVersion() {
        return this.getAppProps().getString(EProperty.MAILER_VERSION);
    }

    @Override
    public boolean isDisabled() {
        return this.getAppProps().getBoolean(EProperty.DISABLE_SNOTIFY);
    }

    @Override
    public boolean isFrozen() {
        return this.getAppProps().getBoolean(EProperty.FREEZE_SNOTIFY);
    }

    public boolean isLiteMode() {
        return this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }

    @Autowired
    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Autowired
    public void setWebSudoManager(WebSudoManager webSudoManager) {
        this.webSudoManager = webSudoManager;
    }

    @FunctionalInterface
    public static interface WebSudoRunnable {
        public void run() throws IOException, ServletException;
    }
}

