/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import net.savignano.snotify.bitbucket.common.SnotifyI18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SnotifyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4969772691968738843L;
    private static final String SERVLET_KEY = "action";
    private static final String USER_KEY = "user";
    private static final String XSRF_TOKEN_KEY = "xsrfToken";
    private static final String XSRF_TOKEN_SESSION_KEY = "atlassian.xsrf.token";
    private static final String XSRF_TOKEN_PARAM_NAME = "atl_token";
    protected static final String SHOW_UPDATED_KEY = "showUpdated";
    protected static final String ERROR_MSG_KEY = "errorMessageHtml";
    protected static final String VALUE_HANDLER_PROVIDER_KEY = "valueHandlerProvider";
    @ComponentImport
    private AuthenticationContext authContext;
    @ComponentImport
    private TemplateRenderer templateRenderer;
    @ComponentImport
    private I18nResolver i18nResolver;
    @ComponentImport
    private ApplicationPropertiesService appPropService;
    private ISnotifyAppProperties appProps;
    private final String templateFolder;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SnotifyServlet(String templateFolder) {
        this.templateFolder = templateFolder;
        if (templateFolder == null) {
            throw new IllegalArgumentException("Template Folder must not be null.");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isAuthenticated()) {
            this.redirectLogin(req, resp);
            return;
        }
        this.renderInput(resp, this.createRendererData(req));
    }

    protected void redirectLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String redirect = resp.encodeRedirectURL(req.getContextPath() + "/login?next=" + req.getServletPath());
        resp.sendRedirect(redirect);
    }

    protected Map<String, Object> createRendererData(HttpServletRequest req) {
        return this.createBaseRendererData(req);
    }

    private Map<String, Object> createXsrfRendererData(HttpServletRequest req) {
        return this.createBaseRendererData(req);
    }

    private Map<String, Object> createBaseRendererData(HttpServletRequest req) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(SERVLET_KEY, (Object)this);
        map.put(USER_KEY, this.getUser());
        map.put(XSRF_TOKEN_KEY, this.getXsrfToken(req.getSession()));
        return map;
    }

    protected String getXsrfToken(HttpSession session) {
        String token = (String)session.getAttribute(XSRF_TOKEN_SESSION_KEY);
        if (token == null) {
            this.getLog().info("No XSRF token found in session. Creating new one.");
            token = DefaultSecureTokenGenerator.getInstance().generateToken();
            session.setAttribute(XSRF_TOKEN_SESSION_KEY, (Object)token);
        }
        return token;
    }

    protected String createTemplatePath(String templateBase, String templateSuffix) {
        StringBuilder builder = new StringBuilder(100);
        builder.append("templates/servlets");
        if (this.templateFolder.charAt(0) != '/') {
            builder.append('/');
        }
        builder.append(this.templateFolder);
        if (this.templateFolder.charAt(this.templateFolder.length() - 1) != '/') {
            builder.append('/');
        }
        builder.append(templateBase);
        if (templateSuffix != null) {
            builder.append('-');
            builder.append(templateSuffix);
        }
        builder.append(".vm");
        return builder.toString();
    }

    protected void renderInput(HttpServletResponse resp, Map<String, Object> data) throws IOException, RenderingException {
        this.renderInput(resp, null, data);
    }

    protected void renderInput(HttpServletResponse resp, String templateSuffix, Map<String, Object> data) throws IOException, RenderingException {
        this.render(resp, this.createTemplatePath("input", null), data);
    }

    protected void renderError(HttpServletResponse resp, Map<String, Object> data) throws IOException, RenderingException {
        this.renderError(resp, null, data);
    }

    protected void renderError(HttpServletResponse resp, String templateSuffix, Map<String, Object> data) throws IOException, RenderingException {
        this.render(resp, this.createTemplatePath("error", templateSuffix), data);
    }

    protected void renderXsrfError(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderingException {
        this.renderError(resp, "xsrf", this.createXsrfRendererData(req));
    }

    protected void render(HttpServletResponse resp, String templatePath, Map<String, Object> data) throws IOException, RenderingException {
        resp.setContentType("text/html;charset=UTF-8");
        this.templateRenderer.render(templatePath, data, (Writer)resp.getWriter());
    }

    public BitbucketUser getUser() {
        ApplicationUser authUser = this.authContext.getCurrentUser();
        if (authUser != null) {
            return new BitbucketUser(authUser);
        }
        return null;
    }

    public boolean isAuthenticated() {
        return this.authContext.isAuthenticated();
    }

    public boolean hasMatchinXsrfToken(HttpServletRequest req) {
        return this.getXsrfToken(req.getSession()).equals(req.getParameter(XSRF_TOKEN_PARAM_NAME));
    }

    public ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }

    @Autowired
    public void setAppProps(ISnotifyAppProperties appProps) {
        this.appProps = appProps;
    }

    @Autowired
    public void setAuthenticationContext(AuthenticationContext authContext) {
        this.authContext = authContext;
    }

    @Autowired
    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    @Autowired
    public void setI18nResolver(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public ApplicationPropertiesService getApplicationPropertiesService() {
        return this.appPropService;
    }

    @Autowired
    public void setApplicationPropertiesService(ApplicationPropertiesService appPropService) {
        this.appPropService = appPropService;
    }

    public ISnotifyI18n getI18n() {
        return new SnotifyI18n(this.i18nResolver, this.appPropService.getLocale());
    }

    protected Logger getLog() {
        return this.log;
    }
}

