/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Map;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.gui.key.info.PgpPublicKeyInfoBuilder;
import net.savignano.snotify.atlassian.gui.key.info.SmimeCertInfoBuilder;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import net.savignano.snotify.bitbucket.gui.key.info.HtmlKeyValueStyle;
import net.savignano.snotify.bitbucket.gui.servlet.SnotifyServlet;
import net.savignano.snotify.bitbucket.gui.servlet.UserSettingsUploadWrapper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class UserSettingsServlet
extends SnotifyServlet {
    private static int MAX_SIZE = 0x100000;
    private static final long serialVersionUID = 2341674333863577455L;
    private static final String DISPLAYED_TAB_KEY = "displayedTab";
    private static final String SUBMIT_SMIME_BUTTON_PARAM = "Submit-SMIME";
    private static final String DELETE_SMIME_BUTTON_PARAM = "Delete-SMIME";
    private static final String SUBMIT_PGP_BUTTON_PARAM = "Submit-PGP";
    private static final String DELETE_PGP_BUTTON_PARAM = "Delete-PGP";
    private static final String FILE_PARAM = "file";
    private ISnotifyUserProperties userProps;

    public UserSettingsServlet() {
        super("user-settings");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isAuthenticated()) {
            resp.sendError(401);
            return;
        }
        if (!JakartaServletFileUpload.isMultipartContent(req)) {
            this.getLog().warn("Request is not a multipart request. Cannot get uploaded file.");
            resp.sendError(400);
            return;
        }
        JakartaServletFileUpload upload = new JakartaServletFileUpload();
        upload.setFileItemFactory(((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)new DiskFileItemFactory.Builder().setBufferSizeMax(MAX_SIZE)).setBufferSize(MAX_SIZE)).get());
        UserSettingsUploadWrapper wrapper = new UserSettingsUploadWrapper(upload, req);
        Data data = new Data();
        data.resp = resp;
        data.req = wrapper;
        data.renderData = this.createRendererData((HttpServletRequest)data.req);
        data.file = data.req.getFile(FILE_PARAM);
        this.dispatchPost(data);
    }

    private void dispatchPost(Data data) throws IOException, ServletException {
        if (!this.hasMatchinXsrfToken((HttpServletRequest)data.req)) {
            this.xsrfError(data);
        } else if (data.req.getParameter(SUBMIT_SMIME_BUTTON_PARAM) != null) {
            this.submitSmime(data);
        } else if (data.req.getParameter(DELETE_SMIME_BUTTON_PARAM) != null) {
            this.deleteSmime(data);
        } else if (data.req.getParameter(SUBMIT_PGP_BUTTON_PARAM) != null) {
            this.submitPgp(data);
        } else if (data.req.getParameter(DELETE_PGP_BUTTON_PARAM) != null) {
            this.deletePgp(data);
        } else {
            data.resp.sendError(400);
        }
    }

    private void xsrfError(Data data) throws RenderingException, IOException {
        this.renderXsrfError((HttpServletRequest)data.req, data.resp);
    }

    private void submitSmime(Data data) throws IOException, ServletException {
        if (data.file == null || data.file.getSize() == 0L) {
            this.renderError(data.resp, "nofile", data.renderData);
            return;
        }
        if (!this.isAllowSmimeUpload()) {
            this.getLog().warn("Uploading of custom S/MIME certificate is not allowed. User: {}", (Object)this.getUser());
            this.renderInput(data.resp, data.renderData);
            return;
        }
        data.renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.SMIME);
        try {
            this.setEmailCert(data.file.getBytes(), this.getUser());
            this.renderInput(data.resp, data.renderData);
        }
        catch (EmailException e) {
            this.getLog().info("Email address mismatch.", (Throwable)e);
            data.renderData.put("errorMessageHtml", e.getMessage());
            this.renderError(data.resp, "email", data.renderData);
        }
        catch (KeyException e) {
            this.getLog().info("Certificate not useable for encryption.", (Throwable)e);
            data.renderData.put("errorMessageHtml", e.getMessage());
            this.renderError(data.resp, "encryption", data.renderData);
        }
        catch (CertificateExpiredException e) {
            this.getLog().info("Certificate expired.", (Throwable)e);
            data.renderData.put("errorMessageHtml", e.getMessage());
            this.renderError(data.resp, "expired", data.renderData);
        }
        catch (CertificateNotYetValidException e) {
            this.getLog().info("Certificate not yet valid.", (Throwable)e);
            data.renderData.put("errorMessageHtml", e.getMessage());
            this.renderError(data.resp, "notyetvalid", data.renderData);
        }
        catch (IOException | CertificateException e) {
            this.getLog().info("Certificate parsing failed.", (Throwable)e);
            data.renderData.put("errorMessageHtml", e.getMessage());
            this.renderError(data.resp, "smime", data.renderData);
        }
        catch (Exception e) {
            if (e instanceof ServletException) {
                throw e;
            }
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private void submitPgp(Data data) throws IOException, ServletException {
        if (data.file == null || data.file.getSize() == 0L) {
            this.renderError(data.resp, "nofile", data.renderData);
            return;
        }
        if (!this.isAllowPgpUpload()) {
            this.getLog().warn("Uploading of custom PGP key is not allowed. User: {}", (Object)this.getUser());
            this.renderInput(data.resp, data.renderData);
            return;
        }
        data.renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.PGP);
        try {
            this.setEmailPgpKey(data.file.getBytes(), this.getUser());
            this.renderInput(data.resp, data.renderData);
        }
        catch (IOException | PGPException e) {
            this.getLog().info("Key parsing failed.", (Throwable)e);
            data.renderData.put("errorMessageHtml", e.getMessage());
            this.renderError(data.resp, "pgp", data.renderData);
        }
        catch (KeyException e) {
            this.getLog().info("No valid key found.", (Throwable)e);
            data.renderData.put("errorMessageHtml", e.getMessage());
            this.renderError(data.resp, "keynotfound", data.renderData);
        }
        catch (Exception e) {
            if (e instanceof ServletException) {
                throw e;
            }
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private void deleteSmime(Data data) throws IOException {
        if (!this.isAllowSmimeUpload()) {
            this.getLog().warn("Deleting of custom S/MIME certificate is not allowed. User: {}", (Object)this.getUser());
            this.renderInput(data.resp, data.renderData);
            return;
        }
        data.renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.SMIME);
        this.clearEmailCert(this.getUser());
        this.renderInput(data.resp, data.renderData);
    }

    private void deletePgp(Data data) throws IOException {
        if (!this.isAllowPgpUpload()) {
            this.getLog().warn("Deleting of custom PGP key is not allowed. User: {}", (Object)this.getUser());
            this.renderInput(data.resp, data.renderData);
            return;
        }
        data.renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.PGP);
        this.clearEmailPgpKey(this.getUser());
        this.renderInput(data.resp, data.renderData);
    }

    private void clearEmailCert(BitbucketUser user) {
        this.getLog().debug("Clearing certificate for user: " + user.getDisplayName());
        this.userProps.setBytes(EProperty.EMAIL_SMIME_CERT, null, user);
        this.userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, null, user);
        this.userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, null, user);
    }

    private void setEmailCert(byte[] cert, BitbucketUser user) throws CertificateException, KeyException {
        this.getLog().debug("Checking certificate for user: " + user.getDisplayName());
        this.checkSmimeCert(cert, user);
        this.getLog().info("Setting certificate for user: " + user.getDisplayName());
        this.userProps.setBytes(EProperty.EMAIL_SMIME_CERT, cert, user);
        this.userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, System.currentTimeMillis(), user);
        this.userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.USER, user);
    }

    private void checkSmimeCert(byte[] cert, BitbucketUser user) throws CertificateException, KeyException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(cert));
        certificate.checkValidity();
        String certEmail = StringUtils.join((Object[])SmimeUtil.getEmails(certificate), (String)", ").toLowerCase();
        if (!certEmail.contains(user.getEmail().toLowerCase())) {
            throw new EmailException(certEmail, user.getDisplayName());
        }
        if (!SmimeUtil.isCertForPurpose(certificate, EKeyPurpose.ENCRYPTION)) {
            throw new InvalidKeyException("Certificate is not useable for encryption.");
        }
    }

    private void clearEmailPgpKey(BitbucketUser user) {
        this.getLog().info("Clearing PGP key for user: {}", (Object)user.getDisplayName());
        this.userProps.setBytes(EProperty.EMAIL_PGP_KEY, null, user);
        this.userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, null, user);
        this.userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, null, user);
        this.userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, null, user);
    }

    private void setEmailPgpKey(byte[] key, BitbucketUser user) throws IOException, PGPException, KeyException {
        this.getLog().debug("Checking PGP key for user: {}", (Object)user.getDisplayName());
        String userEmailAddress = user.getEmail().toLowerCase();
        PGPPublicKeyRingCollection keyRings = PgpUtil.loadPublicKeys(new ByteArrayInputStream(key));
        PGPPublicKeyRing keyRing = PgpUtil.getKeysForEmail(keyRings, userEmailAddress);
        if (keyRing == null) {
            throw new KeyException("Could not find a key ring for email address: " + userEmailAddress);
        }
        PgpEncryptionKey usedKey = new PgpEncryptionKey(keyRing, userEmailAddress);
        PGPPublicKey encKey = usedKey.getKey();
        if (encKey == null) {
            throw new KeyException("Could not find a valid encryption key.");
        }
        this.getLog().info("Setting PGP key for user: {}", (Object)user.getDisplayName());
        this.userProps.setBytes(EProperty.EMAIL_PGP_KEY, key, user);
        this.userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, encKey.getKeyID(), user);
        this.userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, System.currentTimeMillis(), user);
        this.userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.USER, user);
    }

    private String buildCertInfo(byte[] cert, BitbucketUser user) throws CertificateException {
        SmimeCertInfoBuilder builder = new SmimeCertInfoBuilder(cert, this.getI18n());
        builder.setUser(user);
        builder.setUserProps(this.userProps);
        return builder.build(new HtmlKeyValueStyle());
    }

    private String buildKeyInfo(byte[] key, long keyId, BitbucketUser user) throws IOException, PGPException {
        PgpPublicKeyInfoBuilder builder = new PgpPublicKeyInfoBuilder(key, keyId, this.getI18n());
        builder.setUser(user);
        builder.setUserProps(this.userProps);
        return builder.build(new HtmlKeyValueStyle());
    }

    @HtmlSafe
    public String getCertDetails() {
        Object cert = this.getAppProps().getBoolean(EProperty.LITE_MODE) && this.userProps.getEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.class, this.getUser()) != EKeySource.USER ? null : this.userProps.getBytes(EProperty.EMAIL_SMIME_CERT, this.getUser());
        String info = null;
        if (cert == null) {
            info = this.getI18n().getText("snotify-user-settings-webwork.input.smime.notfound");
            this.getLog().debug("No S/MIME certificate specified for user: {}", (Object)this.getUser().getDisplayName());
        } else {
            try {
                info = this.buildCertInfo((byte[])cert, this.getUser());
                this.getLog().debug("Certificate information for user {}: {}", (Object)this.getUser().getDisplayName(), (Object)info);
            }
            catch (CertificateException e) {
                this.getLog().warn("Could not load S/MIME certificate for user: " + this.getUser().getDisplayName(), (Throwable)e);
                info = this.getI18n().getText("snotify-user-settings-webwork.input.smime.error", (Object)e.getLocalizedMessage());
            }
        }
        return info;
    }

    @HtmlSafe
    public String getPgpDetails() {
        Long keyId;
        byte[] key;
        if (this.getAppProps().getBoolean(EProperty.LITE_MODE) && this.userProps.getEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.class, this.getUser()) != EKeySource.USER) {
            key = null;
            keyId = null;
        } else {
            key = this.userProps.getBytes(EProperty.EMAIL_PGP_KEY, this.getUser());
            keyId = this.userProps.getLong(EProperty.EMAIL_PGP_KEY_ID, this.getUser());
        }
        String info = null;
        if (key == null || keyId == null) {
            info = this.getI18n().getText("snotify-user-settings-webwork.input.pgp.notfound");
            this.getLog().debug("No PGP key specified for user: {}", (Object)this.getUser().getDisplayName());
        } else {
            try {
                info = this.buildKeyInfo(key, keyId, this.getUser());
                this.getLog().debug("Key information for user {}: {}", (Object)this.getUser().getDisplayName(), (Object)info);
            }
            catch (IOException | PGPException e) {
                this.getLog().warn("Could not load PGP key for user: " + this.getUser().getDisplayName(), (Throwable)e);
                info = this.getI18n().getText("snotify-user-settings-webwork.input.pgp.error", (Object)e.getLocalizedMessage());
            }
        }
        return info;
    }

    public boolean isChoiceEnabled() {
        switch (this.getTypePriority()) {
            case SMIME_PREFERRED: 
            case PGP_PREFERRED: {
                return true;
            }
            case SMIME_ONLY: 
            case PGP_ONLY: {
                return false;
            }
        }
        this.getLog().warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + String.valueOf((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isSmimeSelected(ECryptographyType cryptoType) {
        if (cryptoType == ECryptographyType.SMIME) {
            return true;
        }
        if (cryptoType == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return true;
            }
            case PGP_ONLY: {
                return false;
            }
            case SMIME_PREFERRED: {
                return this.isAllowSmimeUpload() || !this.isAllowPgpUpload();
            }
            case PGP_PREFERRED: {
                return this.isAllowSmimeUpload() && !this.isAllowPgpUpload();
            }
        }
        this.getLog().warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + String.valueOf((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return true;
    }

    public boolean isPgpSelected(ECryptographyType cryptoType) {
        if (cryptoType == ECryptographyType.PGP) {
            return true;
        }
        if (cryptoType == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: {
                return false;
            }
            case PGP_ONLY: {
                return true;
            }
            case SMIME_PREFERRED: {
                return this.isAllowPgpUpload() && !this.isAllowSmimeUpload();
            }
            case PGP_PREFERRED: {
                return this.isAllowPgpUpload() || !this.isAllowSmimeUpload();
            }
        }
        this.getLog().warn("Unknwon value for 'Encryption Type Priority' found. Value found was '" + String.valueOf((Object)this.getTypePriority()) + "'. It is not yet implemented,");
        return false;
    }

    public boolean isSmimeUploadAllowed() {
        return this.isAllowSmimeUpload() && (this.isChoiceEnabled() || this.isSmimeSelected(null));
    }

    public boolean isPgpUploadAllowed() {
        return this.isAllowPgpUpload() && (this.isChoiceEnabled() || this.isPgpSelected(null));
    }

    public boolean showMultipleUsersError() {
        return (this.isAllowSmimeUpload() || this.isAllowPgpUpload()) && BitbucketUser.lookupUsers(this.getUser().getEmail()).size() > 1;
    }

    private EEncryptionTypePriority getTypePriority() {
        return this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
    }

    private boolean isAllowSmimeUpload() {
        return this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }

    private boolean isAllowPgpUpload() {
        return this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE) || this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }

    @Autowired
    public void setUserProperties(ISnotifyUserProperties userProps) {
        this.userProps = userProps;
    }

    private static final class Data {
        public MultipartHttpServletRequest req;
        public HttpServletResponse resp;
        public Map<String, Object> renderData;
        public MultipartFile file;

        private Data() {
        }
    }

    private static final class EmailException
    extends CertificateException {
        private static final long serialVersionUID = 7315460494368546346L;

        private EmailException(String email, String user) {
            super("Email address(es) of certificate (" + email + ") do not match email of user: " + user);
        }
    }
}

