/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.savignano.cryptography.Constants;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.jakarta.servlet6.JakartaServletFileUpload;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;

public class UserSettingsUploadWrapper
extends DefaultMultipartHttpServletRequest {
    public UserSettingsUploadWrapper(JakartaServletFileUpload<? extends FileItem<?>, ?> upload, HttpServletRequest request) throws IOException {
        super(request);
        this.parse(upload);
    }

    private void parse(JakartaServletFileUpload<? extends FileItem<?>, ?> upload) throws IOException {
        HashMap<String, List<FileItemWrapper>> files = new HashMap<String, List<FileItemWrapper>>();
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        HashMap<String, String> contentTypes = new HashMap<String, String>();
        for (FileItem<?> item : upload.parseRequest(this.getRequest())) {
            System.out.println("FileItem: " + String.valueOf(item));
            String name = item.getFieldName();
            if (item.isFormField()) {
                params.put(name, new String[]{item.getString(Constants.UTF8_CHARSET)});
                contentTypes.put(name, item.getContentType());
                continue;
            }
            files.put(name, Collections.singletonList(new FileItemWrapper(item)));
        }
        this.setMultipartFiles((MultiValueMap)new MultiValueMapAdapter(files));
        this.setMultipartParameters(params);
        this.setMultipartParameterContentTypes(contentTypes);
    }

    private static final class FileItemWrapper
    implements MultipartFile {
        private final FileItem<?> item;

        public FileItemWrapper(FileItem<?> item) {
            this.item = item;
        }

        public String getName() {
            return this.item.getFieldName();
        }

        public String getOriginalFilename() {
            return this.item.getName();
        }

        public String getContentType() {
            return this.item.getContentType();
        }

        public boolean isEmpty() {
            return this.getSize() != 0L;
        }

        public long getSize() {
            return this.item.getSize();
        }

        public byte[] getBytes() throws IOException {
            return this.item.get();
        }

        public InputStream getInputStream() throws IOException {
            return this.item.getInputStream();
        }

        public void transferTo(File dest) throws IOException, IllegalStateException {
            throw new IllegalStateException("Not yet implemented.");
        }

        public String toString() {
            return this.item.toString();
        }
    }
}

