/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;

class StreamUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();

    StreamUtil() {
    }

    static int findLimit(InputStream in) {
        if (in instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)in).available();
        }
        if (in instanceof FileInputStream) {
            try {
                long size;
                FileChannel channel = ((FileInputStream)in).getChannel();
                long l = size = channel != null ? channel.size() : Integer.MAX_VALUE;
                if (size < Integer.MAX_VALUE) {
                    return (int)size;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }

    static void writeNewPacketLength(OutputStream out, long bodyLen) throws IOException {
        if (bodyLen < 192L) {
            out.write((byte)bodyLen);
        } else if (bodyLen <= 8383L) {
            out.write((byte)(((bodyLen -= 192L) >> 8 & 0xFFL) + 192L));
            out.write((byte)bodyLen);
        } else {
            out.write(255);
            StreamUtil.writeBodyLen(out, bodyLen);
        }
    }

    static void writeBodyLen(OutputStream out, long bodyLen) throws IOException {
        out.write((byte)(bodyLen >> 24));
        out.write((byte)(bodyLen >> 16));
        out.write((byte)(bodyLen >> 8));
        out.write((byte)bodyLen);
    }

    static void writeKeyID(BCPGOutputStream pOut, long keyID) throws IOException {
        pOut.write((byte)(keyID >> 56));
        pOut.write((byte)(keyID >> 48));
        pOut.write((byte)(keyID >> 40));
        pOut.write((byte)(keyID >> 32));
        pOut.write((byte)(keyID >> 24));
        pOut.write((byte)(keyID >> 16));
        pOut.write((byte)(keyID >> 8));
        pOut.write((byte)keyID);
    }

    static long readKeyID(BCPGInputStream in) throws IOException {
        long keyID = (long)in.read() << 56;
        keyID |= (long)in.read() << 48;
        keyID |= (long)in.read() << 40;
        keyID |= (long)in.read() << 32;
        keyID |= (long)in.read() << 24;
        keyID |= (long)in.read() << 16;
        return (keyID |= (long)in.read() << 8) | (long)in.read();
    }

    static void writeTime(BCPGOutputStream pOut, long time) throws IOException {
        pOut.write((byte)(time >> 24));
        pOut.write((byte)(time >> 16));
        pOut.write((byte)(time >> 8));
        pOut.write((byte)time);
    }
}

