/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ContainedPacket;

public class TrustPacket
extends ContainedPacket {
    byte[] levelAndTrustAmount;

    public TrustPacket(BCPGInputStream in) throws IOException {
        super(12);
        int ch;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        while ((ch = in.read()) >= 0) {
            bOut.write(ch);
        }
        this.levelAndTrustAmount = bOut.toByteArray();
    }

    public TrustPacket(int trustCode) {
        super(12);
        this.levelAndTrustAmount = new byte[1];
        this.levelAndTrustAmount[0] = (byte)trustCode;
    }

    public byte[] getLevelAndTrustAmount() {
        return this.levelAndTrustAmount;
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(12, this.levelAndTrustAmount);
    }
}

