/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms.bc;

import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientOperator;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcPasswordRecipient;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.EnvelopedDataHelper;
import net.savignano.thirdparty.org.bouncycastle.crypto.BufferedBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.StreamCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.io.CipherInputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import net.savignano.thirdparty.org.bouncycastle.operator.InputDecryptor;

public class BcPasswordEnvelopedRecipient
extends BcPasswordRecipient {
    public BcPasswordEnvelopedRecipient(char[] password) {
        super(password);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] derivedKey, byte[] encryptedContentEncryptionKey) throws CMSException {
        KeyParameter secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, derivedKey, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataOut) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataOut, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataOut, (StreamCipher)dataCipher);
            }
        });
    }
}

