/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1BitString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERBitString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X962Parameters;
import net.savignano.thirdparty.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.internal.asn1.edec.EdECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.jcajce.CompositePrivateKey;
import net.savignano.thirdparty.org.bouncycastle.jcajce.CompositePublicKey;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeSignaturesConstants;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import net.savignano.thirdparty.org.bouncycastle.util.Exceptions;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    private static final AlgorithmIdentifier dilithium2Identifier = new AlgorithmIdentifier(BCObjectIdentifiers.dilithium2);
    private static final AlgorithmIdentifier dilithium3Identifier = new AlgorithmIdentifier(BCObjectIdentifiers.dilithium3);
    private static final AlgorithmIdentifier dilithium5Identifier = new AlgorithmIdentifier(BCObjectIdentifiers.dilithium5);
    private static final AlgorithmIdentifier falcon512Identifier = new AlgorithmIdentifier(BCObjectIdentifiers.falcon_512);
    private static final AlgorithmIdentifier ed25519Identifier = new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed25519);
    private static final AlgorithmIdentifier ecdsaP256Identifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(SECObjectIdentifiers.secp256r1));
    private static final AlgorithmIdentifier ecdsaBrainpoolP256r1Identifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(TeleTrusTObjectIdentifiers.brainpoolP256r1));
    private static final AlgorithmIdentifier rsaIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
    private static final AlgorithmIdentifier ed448Identifier = new AlgorithmIdentifier(EdECObjectIdentifiers.id_Ed448);
    private static final AlgorithmIdentifier ecdsaP384Identifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(SECObjectIdentifiers.secp384r1));
    private static final AlgorithmIdentifier ecdsaBrainpoolP384r1Identifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new X962Parameters(TeleTrusTObjectIdentifiers.brainpoolP384r1));

    @Override
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (key instanceof PrivateKey) {
                return this.generatePrivate(PrivateKeyInfo.getInstance(key.getEncoded()));
            }
            if (key instanceof PublicKey) {
                return this.generatePublic(SubjectPublicKeyInfo.getInstance(key.getEncoded()));
            }
        }
        catch (IOException e) {
            throw new InvalidKeyException("Key could not be parsed: " + e.getMessage());
        }
        throw new InvalidKeyException("Key not recognized");
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo keyInfo) throws IOException {
        ASN1Sequence seq = DERSequence.getInstance(keyInfo.parsePrivateKey());
        ASN1ObjectIdentifier keyIdentifier = keyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        try {
            List<KeyFactory> factories = this.getKeyFactoriesFromIdentifier(keyIdentifier);
            PrivateKey[] privateKeys = new PrivateKey[seq.size()];
            for (int i = 0; i < seq.size(); ++i) {
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(PrivateKeyInfo.getInstance(seq.getObjectAt(i)).getEncoded());
                privateKeys[i] = factories.get(i).generatePrivate(keySpec);
            }
            return new CompositePrivateKey(keyIdentifier, privateKeys);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.ioException(e.getMessage(), e);
        }
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo keyInfo) throws IOException {
        ASN1Sequence seq = DERSequence.getInstance(keyInfo.getPublicKeyData().getBytes());
        ASN1ObjectIdentifier keyIdentifier = keyInfo.getAlgorithm().getAlgorithm();
        try {
            List<KeyFactory> factories = this.getKeyFactoriesFromIdentifier(keyIdentifier);
            ASN1BitString[] componentBitStrings = new ASN1BitString[seq.size()];
            for (int i = 0; i < seq.size(); ++i) {
                componentBitStrings[i] = seq.getObjectAt(i) instanceof DEROctetString ? new DERBitString(((DEROctetString)seq.getObjectAt(i)).getOctets()) : (DERBitString)seq.getObjectAt(i);
            }
            X509EncodedKeySpec[] x509EncodedKeySpecs = this.getKeysSpecs(keyIdentifier, componentBitStrings);
            PublicKey[] publicKeys = new PublicKey[seq.size()];
            for (int i = 0; i < seq.size(); ++i) {
                publicKeys[i] = factories.get(i).generatePublic(x509EncodedKeySpecs[i]);
            }
            return new CompositePublicKey(keyIdentifier, publicKeys);
        }
        catch (GeneralSecurityException e) {
            throw Exceptions.ioException(e.getMessage(), e);
        }
    }

    private List<KeyFactory> getKeyFactoriesFromIdentifier(ASN1ObjectIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, NoSuchProviderException {
        ArrayList<KeyFactory> factories = new ArrayList<KeyFactory>();
        ArrayList<String> algorithmNames = new ArrayList<String>();
        switch (CompositeSignaturesConstants.ASN1IdentifierCompositeNameMap.get(algorithmIdentifier)) {
            case MLDSA44_Ed25519_SHA512: 
            case MLDSA65_Ed25519_SHA512: {
                algorithmNames.add("Dilithium");
                algorithmNames.add("Ed25519");
                break;
            }
            case MLDSA87_Ed448_SHA512: {
                algorithmNames.add("Dilithium");
                algorithmNames.add("Ed448");
                break;
            }
            case MLDSA44_RSA2048_PSS_SHA256: 
            case MLDSA44_RSA2048_PKCS15_SHA256: 
            case MLDSA65_RSA3072_PSS_SHA512: 
            case MLDSA65_RSA3072_PKCS15_SHA512: {
                algorithmNames.add("Dilithium");
                algorithmNames.add("RSA");
                break;
            }
            case MLDSA44_ECDSA_P256_SHA256: 
            case MLDSA44_ECDSA_brainpoolP256r1_SHA256: 
            case MLDSA65_ECDSA_P256_SHA512: 
            case MLDSA65_ECDSA_brainpoolP256r1_SHA512: 
            case MLDSA87_ECDSA_P384_SHA512: 
            case MLDSA87_ECDSA_brainpoolP384r1_SHA512: {
                algorithmNames.add("Dilithium");
                algorithmNames.add("ECDSA");
                break;
            }
            case Falcon512_Ed25519_SHA512: {
                algorithmNames.add("Falcon");
                algorithmNames.add("Ed25519");
                break;
            }
            case Falcon512_ECDSA_P256_SHA256: 
            case Falcon512_ECDSA_brainpoolP256r1_SHA256: {
                algorithmNames.add("Falcon");
                algorithmNames.add("ECDSA");
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create KeyFactories. Unsupported algorithm identifier.");
            }
        }
        factories.add(KeyFactory.getInstance((String)algorithmNames.get(0), "SAVIGNANO-BC"));
        factories.add(KeyFactory.getInstance((String)algorithmNames.get(1), "SAVIGNANO-BC"));
        return Collections.unmodifiableList(factories);
    }

    private X509EncodedKeySpec[] getKeysSpecs(ASN1ObjectIdentifier algorithmIdentifier, ASN1BitString[] subjectPublicKeys) throws IOException {
        X509EncodedKeySpec[] specs = new X509EncodedKeySpec[subjectPublicKeys.length];
        SubjectPublicKeyInfo[] keyInfos = new SubjectPublicKeyInfo[subjectPublicKeys.length];
        switch (CompositeSignaturesConstants.ASN1IdentifierCompositeNameMap.get(algorithmIdentifier)) {
            case MLDSA44_Ed25519_SHA512: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium2Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ed25519Identifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA44_ECDSA_P256_SHA256: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium2Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ecdsaP256Identifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA44_ECDSA_brainpoolP256r1_SHA256: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium2Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ecdsaBrainpoolP256r1Identifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA44_RSA2048_PSS_SHA256: 
            case MLDSA44_RSA2048_PKCS15_SHA256: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium2Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(rsaIdentifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA65_Ed25519_SHA512: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium3Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ed25519Identifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA65_ECDSA_P256_SHA512: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium3Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ecdsaP256Identifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA65_ECDSA_brainpoolP256r1_SHA512: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium3Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ecdsaBrainpoolP256r1Identifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA65_RSA3072_PSS_SHA512: 
            case MLDSA65_RSA3072_PKCS15_SHA512: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium3Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(rsaIdentifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA87_Ed448_SHA512: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium5Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ed448Identifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA87_ECDSA_P384_SHA512: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium5Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ecdsaP384Identifier, subjectPublicKeys[1]);
                break;
            }
            case MLDSA87_ECDSA_brainpoolP384r1_SHA512: {
                keyInfos[0] = new SubjectPublicKeyInfo(dilithium5Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ecdsaBrainpoolP384r1Identifier, subjectPublicKeys[1]);
                break;
            }
            case Falcon512_Ed25519_SHA512: {
                keyInfos[0] = new SubjectPublicKeyInfo(falcon512Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ed25519Identifier, subjectPublicKeys[1]);
                break;
            }
            case Falcon512_ECDSA_P256_SHA256: {
                keyInfos[0] = new SubjectPublicKeyInfo(falcon512Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ecdsaP256Identifier, subjectPublicKeys[1]);
                break;
            }
            case Falcon512_ECDSA_brainpoolP256r1_SHA256: {
                keyInfos[0] = new SubjectPublicKeyInfo(falcon512Identifier, subjectPublicKeys[0]);
                keyInfos[1] = new SubjectPublicKeyInfo(ecdsaBrainpoolP256r1Identifier, subjectPublicKeys[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot create key specs. Unsupported algorithm identifier.");
            }
        }
        specs[0] = new X509EncodedKeySpec(keyInfos[0].getEncoded());
        specs[1] = new X509EncodedKeySpec(keyInfos[1].getEncoded());
        return specs;
    }
}

