/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jce.provider;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.savignano.thirdparty.org.bouncycastle.jce.X509LDAPCertStoreParameters;
import net.savignano.thirdparty.org.bouncycastle.util.Selector;
import net.savignano.thirdparty.org.bouncycastle.util.StoreException;
import net.savignano.thirdparty.org.bouncycastle.x509.X509CRLStoreSelector;
import net.savignano.thirdparty.org.bouncycastle.x509.X509StoreParameters;
import net.savignano.thirdparty.org.bouncycastle.x509.X509StoreSpi;
import net.savignano.thirdparty.org.bouncycastle.x509.util.LDAPStoreHelper;

public class X509StoreLDAPCRLs
extends X509StoreSpi {
    private LDAPStoreHelper helper;

    @Override
    public void engineInit(X509StoreParameters params) {
        if (!(params instanceof X509LDAPCertStoreParameters)) {
            throw new IllegalArgumentException("Initialization parameters must be an instance of " + X509LDAPCertStoreParameters.class.getName() + ".");
        }
        this.helper = new LDAPStoreHelper((X509LDAPCertStoreParameters)params);
    }

    @Override
    public Collection engineGetMatches(Selector selector) throws StoreException {
        if (!(selector instanceof X509CRLStoreSelector)) {
            return Collections.EMPTY_SET;
        }
        X509CRLStoreSelector xselector = (X509CRLStoreSelector)selector;
        HashSet set = new HashSet();
        if (xselector.isDeltaCRLIndicatorEnabled()) {
            set.addAll(this.helper.getDeltaCertificateRevocationLists(xselector));
        } else {
            set.addAll(this.helper.getDeltaCertificateRevocationLists(xselector));
            set.addAll(this.helper.getAttributeAuthorityRevocationLists(xselector));
            set.addAll(this.helper.getAttributeCertificateRevocationLists(xselector));
            set.addAll(this.helper.getAuthorityRevocationLists(xselector));
            set.addAll(this.helper.getCertificateRevocationLists(xselector));
        }
        return set;
    }
}

