/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.oer.OEROptional;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.HashedData;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.Ieee1609Dot2Data;

public class SignedDataPayload
extends ASN1Object {
    private final Ieee1609Dot2Data data;
    private final HashedData extDataHash;

    public SignedDataPayload(Ieee1609Dot2Data data, HashedData extDataHash) {
        this.data = data;
        this.extDataHash = extDataHash;
    }

    private SignedDataPayload(ASN1Sequence sequence) {
        if (sequence.size() != 2) {
            throw new IllegalArgumentException("expected sequence size of 2");
        }
        this.data = OEROptional.getValue(Ieee1609Dot2Data.class, sequence.getObjectAt(0));
        this.extDataHash = OEROptional.getValue(HashedData.class, sequence.getObjectAt(1));
    }

    public static SignedDataPayload getInstance(Object o) {
        if (o instanceof SignedDataPayload) {
            return (SignedDataPayload)o;
        }
        if (o != null) {
            return new SignedDataPayload(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{OEROptional.getInstance(this.data), OEROptional.getInstance(this.extDataHash)});
    }

    public Ieee1609Dot2Data getData() {
        return this.data;
    }

    public HashedData getExtDataHash() {
        return this.extDataHash;
    }

    public static class Builder {
        private Ieee1609Dot2Data data;
        private HashedData extDataHash;

        public Builder setData(Ieee1609Dot2Data data) {
            this.data = data;
            return this;
        }

        public Builder setExtDataHash(HashedData extDataHash) {
            this.extDataHash = extDataHash;
            return this;
        }

        public SignedDataPayload createSignedDataPayload() {
            return new SignedDataPayload(this.data, this.extDataHash);
        }
    }
}

