/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2dot1;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1IA5String;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERIA5String;
import net.savignano.thirdparty.org.bouncycastle.oer.OEROptional;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ItsUtils;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.CertificateType;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.ToBeSignedCertificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.Time32;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.UINT8;

public class EeEcaCertRequest
extends ASN1Object {
    private final UINT8 version;
    private final Time32 generationTime;
    private final CertificateType type;
    private final ToBeSignedCertificate tbsCert;
    private final ASN1IA5String canonicalId;

    public EeEcaCertRequest(UINT8 version, Time32 generationTime, CertificateType type, ToBeSignedCertificate tbsCert, ASN1IA5String canonicalId) {
        this.version = version;
        this.generationTime = generationTime;
        this.type = type;
        this.tbsCert = tbsCert;
        this.canonicalId = canonicalId;
    }

    private EeEcaCertRequest(ASN1Sequence seq) {
        if (seq.size() != 5) {
            throw new IllegalArgumentException("expected sequence size of 5");
        }
        this.version = UINT8.getInstance(seq.getObjectAt(0));
        this.generationTime = Time32.getInstance(seq.getObjectAt(1));
        this.type = CertificateType.getInstance(seq.getObjectAt(2));
        this.tbsCert = ToBeSignedCertificate.getInstance(seq.getObjectAt(3));
        this.canonicalId = OEROptional.getInstance(seq.getObjectAt(4)).getObject(ASN1IA5String.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EeEcaCertRequest getInstance(Object o) {
        if (o instanceof EeEcaCertRequest) {
            return (EeEcaCertRequest)o;
        }
        if (o != null) {
            return new EeEcaCertRequest(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return ItsUtils.toSequence(this.version, this.generationTime, this.type, this.tbsCert, OEROptional.getInstance(this.canonicalId));
    }

    public UINT8 getVersion() {
        return this.version;
    }

    public Time32 getGenerationTime() {
        return this.generationTime;
    }

    public CertificateType getType() {
        return this.type;
    }

    public ToBeSignedCertificate getTbsCert() {
        return this.tbsCert;
    }

    public ASN1IA5String getCanonicalId() {
        return this.canonicalId;
    }

    public static class Builder {
        private UINT8 version;
        private Time32 generationTime;
        private CertificateType type;
        private ToBeSignedCertificate tbsCert;
        private DERIA5String canonicalId;

        public Builder setVersion(UINT8 version) {
            this.version = version;
            return this;
        }

        public Builder setGenerationTime(Time32 generationTime) {
            this.generationTime = generationTime;
            return this;
        }

        public Builder setType(CertificateType type) {
            this.type = type;
            return this;
        }

        public Builder setTbsCert(ToBeSignedCertificate tbsCert) {
            this.tbsCert = tbsCert;
            return this;
        }

        public Builder setCanonicalId(DERIA5String canonicalId) {
            this.canonicalId = canonicalId;
            return this;
        }

        public Builder setCanonicalId(String canonicalId) {
            this.canonicalId = new DERIA5String(canonicalId);
            return this;
        }

        public EeEcaCertRequest createEeEcaCertRequest() {
            return new EeEcaCertRequest(this.version, this.generationTime, this.type, this.tbsCert, this.canonicalId);
        }
    }
}

