/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.examples;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.util.Date;
import javax.crypto.spec.DHParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ArmoredOutputStream;
import net.savignano.thirdparty.org.bouncycastle.jce.provider.BouncyCastleProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKeyRingGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPair;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class DSAElGamalKeyRingGenerator {
    private static final int SIG_HASH = 10;
    private static final int[] HASH_PREFERENCES = new int[]{10, 9, 8, 11};
    private static final int[] SYM_PREFERENCES = new int[]{9, 8, 7};
    private static final int[] COMP = new int[]{2, 3, 2, 0};

    private static void exportKeyPair(OutputStream secretOut, OutputStream publicOut, KeyPair dsaKp, KeyPair elgKp, String identity, char[] passPhrase, boolean armor) throws IOException, PGPException {
        if (armor) {
            secretOut = new ArmoredOutputStream(secretOut);
        }
        JcaPGPKeyPair dsaKeyPair = new JcaPGPKeyPair(17, dsaKp, new Date());
        JcaPGPKeyPair elgKeyPair = new JcaPGPKeyPair(16, elgKp, new Date());
        PGPDigestCalculator sha1Calc = new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
        JcaPGPContentSignerBuilder contentSignerBuilder = new JcaPGPContentSignerBuilder(dsaKeyPair.getPublicKey().getAlgorithm(), 10);
        PBESecretKeyEncryptor secretKeyEncryptor = new JcePBESecretKeyEncryptorBuilder(9, sha1Calc).setProvider("SAVIGNANO-BC").build(passPhrase);
        PGPSignatureSubpacketGenerator primaryHashedSubpackets = DSAElGamalKeyRingGenerator.getPrimaryKeyHashedSubpackets();
        primaryHashedSubpackets.setIssuerFingerprint(false, dsaKeyPair.getPublicKey());
        PGPKeyRingGenerator keyRingGen = new PGPKeyRingGenerator(19, dsaKeyPair, identity, sha1Calc, primaryHashedSubpackets.generate(), null, contentSignerBuilder, secretKeyEncryptor);
        PGPSignatureSubpacketGenerator subkeyHashedSubpackets = DSAElGamalKeyRingGenerator.getEncryptionKeyHashedSubpackets();
        subkeyHashedSubpackets.setIssuerFingerprint(false, dsaKeyPair.getPublicKey());
        keyRingGen.addSubKey(elgKeyPair, subkeyHashedSubpackets.generate(), null);
        keyRingGen.generateSecretKeyRing().encode(secretOut);
        secretOut.close();
        if (armor) {
            publicOut = new ArmoredOutputStream(publicOut);
        }
        keyRingGen.generatePublicKeyRing().encode(publicOut);
        publicOut.close();
    }

    private static PGPSignatureSubpacketGenerator getEncryptionKeyHashedSubpackets() {
        PGPSignatureSubpacketGenerator gen = new PGPSignatureSubpacketGenerator();
        gen.setKeyFlags(true, 12);
        return gen;
    }

    private static PGPSignatureSubpacketGenerator getPrimaryKeyHashedSubpackets() {
        PGPSignatureSubpacketGenerator gen = new PGPSignatureSubpacketGenerator();
        gen.setPreferredHashAlgorithms(false, HASH_PREFERENCES);
        gen.setPreferredSymmetricAlgorithms(false, SYM_PREFERENCES);
        gen.setPreferredCompressionAlgorithms(false, COMP);
        gen.setFeature(false, (byte)1);
        gen.setKeyFlags(true, 3);
        return gen;
    }

    private static KeyPair generateElGamalKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        KeyPairGenerator elgKpg = KeyPairGenerator.getInstance("ELGAMAL", "SAVIGNANO-BC");
        BigInteger g = new BigInteger("2", 16);
        BigInteger p = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF", 16);
        DHParameterSpec elParams = new DHParameterSpec(p, g);
        elgKpg.initialize(elParams);
        KeyPair elgKp = elgKpg.generateKeyPair();
        return elgKp;
    }

    private static KeyPair generateDSAKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPairGenerator dsaKpg = KeyPairGenerator.getInstance("DSA", "SAVIGNANO-BC");
        dsaKpg.initialize(3072);
        KeyPair dsaKp = dsaKpg.generateKeyPair();
        return dsaKp;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (args.length < 2) {
            System.out.println("DSAElGamalKeyRingGenerator [-a] identity passPhrase");
            System.exit(0);
        }
        KeyPair dsaKp = DSAElGamalKeyRingGenerator.generateDSAKeyPair();
        KeyPair elgKp = DSAElGamalKeyRingGenerator.generateElGamalKeyPair();
        if (args[0].equals("-a")) {
            if (args.length < 3) {
                System.out.println("DSAElGamalKeyRingGenerator [-a] identity passPhrase");
                System.exit(0);
            }
            FileOutputStream out1 = new FileOutputStream("secret.asc");
            FileOutputStream out2 = new FileOutputStream("pub.asc");
            DSAElGamalKeyRingGenerator.exportKeyPair(out1, out2, dsaKp, elgKp, args[1], args[2].toCharArray(), true);
        } else {
            FileOutputStream out1 = new FileOutputStream("secret.bpg");
            FileOutputStream out2 = new FileOutputStream("pub.bpg");
            DSAElGamalKeyRingGenerator.exportKeyPair(out1, out2, dsaKp, elgKp, args[0], args[1].toCharArray(), false);
        }
    }
}

