/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.Composer;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.DigestUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMOtsSignature;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSContext;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSSignature;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LmsUtils;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Encodable;
import net.savignano.thirdparty.org.bouncycastle.util.Objects;
import net.savignano.thirdparty.org.bouncycastle.util.io.Streams;

class LMOtsPublicKey
implements Encodable {
    private final LMOtsParameters parameter;
    private final byte[] I;
    private final int q;
    private final byte[] K;

    LMOtsPublicKey(LMOtsParameters parameter, byte[] i, int q, byte[] k) {
        this.parameter = parameter;
        this.I = i;
        this.q = q;
        this.K = k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LMOtsPublicKey getInstance(Object src) throws Exception {
        if (src instanceof LMOtsPublicKey) {
            return (LMOtsPublicKey)src;
        }
        if (src instanceof DataInputStream) {
            LMOtsParameters parameter = LMOtsParameters.getParametersForType(((DataInputStream)src).readInt());
            byte[] I = new byte[16];
            ((DataInputStream)src).readFully(I);
            int q = ((DataInputStream)src).readInt();
            byte[] K = new byte[parameter.getN()];
            ((DataInputStream)src).readFully(K);
            return new LMOtsPublicKey(parameter, I, q, K);
        }
        if (src instanceof byte[]) {
            try (InputStream in = null;){
                in = new DataInputStream(new ByteArrayInputStream((byte[])src));
                LMOtsPublicKey lMOtsPublicKey = LMOtsPublicKey.getInstance(in);
                return lMOtsPublicKey;
            }
        }
        if (src instanceof InputStream) {
            return LMOtsPublicKey.getInstance(Streams.readAll((InputStream)src));
        }
        throw new IllegalArgumentException("cannot parse " + src);
    }

    public LMOtsParameters getParameter() {
        return this.parameter;
    }

    public byte[] getI() {
        return this.I;
    }

    public int getQ() {
        return this.q;
    }

    public byte[] getK() {
        return this.K;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LMOtsPublicKey that = (LMOtsPublicKey)o;
        return this.q == that.q && Objects.areEqual(this.parameter, that.parameter) && Arrays.areEqual(this.I, that.I) && Arrays.areEqual(this.K, that.K);
    }

    public int hashCode() {
        int result = this.q;
        result = 31 * result + Objects.hashCode(this.parameter);
        result = 31 * result + Arrays.hashCode(this.I);
        result = 31 * result + Arrays.hashCode(this.K);
        return result;
    }

    @Override
    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.parameter.getType()).bytes(this.I).u32str(this.q).bytes(this.K).build();
    }

    LMSContext createOtsContext(LMOtsSignature signature) {
        Digest ctx = DigestUtil.getDigest(this.parameter);
        LmsUtils.byteArray(this.I, ctx);
        LmsUtils.u32str(this.q, ctx);
        LmsUtils.u16str((short)-32383, ctx);
        LmsUtils.byteArray(signature.getC(), ctx);
        return new LMSContext(this, signature, ctx);
    }

    LMSContext createOtsContext(LMSSignature signature) {
        Digest ctx = DigestUtil.getDigest(this.parameter);
        LmsUtils.byteArray(this.I, ctx);
        LmsUtils.u32str(this.q, ctx);
        LmsUtils.u16str((short)-32383, ctx);
        LmsUtils.byteArray(signature.getOtsSignature().getC(), ctx);
        return new LMSContext(this, signature, ctx);
    }
}

