/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus;

import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.HarakaSBase;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus.HarakaSXof;

class HarakaS256Digest
extends HarakaSBase
implements Digest {
    public HarakaS256Digest(HarakaSXof base) {
        this.haraka256_rc = base.haraka256_rc;
    }

    @Override
    public String getAlgorithmName() {
        return "HarakaS-256";
    }

    @Override
    public int getDigestSize() {
        return 32;
    }

    @Override
    public void update(byte in) {
        if (this.off > 31) {
            throw new IllegalArgumentException("total input cannot be more than 32 bytes");
        }
        this.buffer[this.off++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (this.off > 32 - len) {
            throw new IllegalArgumentException("total input cannot be more than 32 bytes");
        }
        System.arraycopy(in, inOff, this.buffer, this.off, len);
        this.off += len;
    }

    @Override
    public int doFinal(byte[] output, int outOff) {
        byte[] s = new byte[32];
        this.haraka256Perm(s);
        HarakaS256Digest.xor(s, 0, this.buffer, 0, output, outOff, 32);
        this.reset();
        return output.length;
    }

    @Override
    public void reset() {
        super.reset();
    }
}

