/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.x509;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.Certificate;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.CertificatePair;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.BCJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jce.provider.X509CertificateObject;
import net.savignano.thirdparty.org.bouncycastle.x509.ExtCertificateEncodingException;

public class X509CertificatePair {
    private final JcaJceHelper bcHelper = new BCJcaJceHelper();
    private X509Certificate forward;
    private X509Certificate reverse;

    public X509CertificatePair(X509Certificate forward, X509Certificate reverse) {
        this.forward = forward;
        this.reverse = reverse;
    }

    public X509CertificatePair(CertificatePair pair) throws CertificateParsingException {
        if (pair.getForward() != null) {
            this.forward = new X509CertificateObject(pair.getForward());
        }
        if (pair.getReverse() != null) {
            this.reverse = new X509CertificateObject(pair.getReverse());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        Certificate f = null;
        Certificate r = null;
        try {
            if (this.forward != null && (f = Certificate.getInstance(new ASN1InputStream(this.forward.getEncoded()).readObject())) == null) {
                throw new CertificateEncodingException("unable to get encoding for forward");
            }
            if (this.reverse != null && (r = Certificate.getInstance(new ASN1InputStream(this.reverse.getEncoded()).readObject())) == null) {
                throw new CertificateEncodingException("unable to get encoding for reverse");
            }
            return new CertificatePair(f, r).getEncoded("DER");
        }
        catch (IllegalArgumentException e) {
            throw new ExtCertificateEncodingException(e.toString(), e);
        }
        catch (IOException e) {
            throw new ExtCertificateEncodingException(e.toString(), e);
        }
    }

    public X509Certificate getForward() {
        return this.forward;
    }

    public X509Certificate getReverse() {
        return this.reverse;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof X509CertificatePair)) {
            return false;
        }
        X509CertificatePair pair = (X509CertificatePair)o;
        boolean equalReverse = true;
        boolean equalForward = true;
        if (this.forward != null) {
            equalForward = this.forward.equals(pair.forward);
        } else if (pair.forward != null) {
            equalForward = false;
        }
        if (this.reverse != null) {
            equalReverse = this.reverse.equals(pair.reverse);
        } else if (pair.reverse != null) {
            equalReverse = false;
        }
        return equalForward && equalReverse;
    }

    public int hashCode() {
        int hash = -1;
        if (this.forward != null) {
            hash ^= this.forward.hashCode();
        }
        if (this.reverse != null) {
            hash *= 17;
            hash ^= this.reverse.hashCode();
        }
        return hash;
    }
}

