/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key;

import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.pgp.PgpDecryptionKey;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.pgp.PgpOldValidationKey;
import net.savignano.cryptography.key.pgp.PgpSignKey;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.cryptography.key.smime.SmimeDecryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeSignKey;

public class ValidityKeyFactory {
    private static ValidityKeyFactory instance;

    public static final ValidityKeyFactory getInstance() {
        if (instance == null) {
            instance = new ValidityKeyFactory();
        }
        return instance;
    }

    public <T extends ICryptographyKey<?>> T create(Class<T> keyType, EKeyValidity keyValidity) {
        return this.create(keyType, keyValidity, EKeySource.UNKNOWN);
    }

    public <T extends ICryptographyKey<?>> T create(Class<T> keyType, EKeyValidity keyValidity, EKeySource keySource) {
        this.sanityCheck(keyType, keyValidity, keySource);
        return (T)this.createKey(keyType, keyValidity, keySource);
    }

    private ICryptographyKey<?> createKey(Class<? extends ICryptographyKey<?>> keyType, EKeyValidity keyValidity, EKeySource keySource) {
        if (keyType.equals(PgpDecryptionKey.class)) {
            return new PgpDecryptionKey(keyValidity, keySource);
        }
        if (keyType.equals(PgpEncryptionKey.class)) {
            return new PgpEncryptionKey(keyValidity, keySource);
        }
        if (keyType.equals(PgpSignKey.class)) {
            return new PgpSignKey(keyValidity, keySource);
        }
        if (keyType.equals(PgpOldValidationKey.class)) {
            return new PgpOldValidationKey(keyValidity, keySource);
        }
        if (keyType.equals(PgpValidationKey.class)) {
            return new PgpValidationKey(keyValidity, keySource);
        }
        if (keyType.equals(SmimeDecryptionKey.class)) {
            return new SmimeDecryptionKey(keyValidity, keySource);
        }
        if (keyType.equals(SmimeEncryptionKey.class)) {
            return new SmimeEncryptionKey(keyValidity, keySource);
        }
        if (keyType.equals(SmimeSignKey.class)) {
            return new SmimeSignKey(keyValidity, keySource);
        }
        return this.createViaReflection(keyType, keyValidity, keySource);
    }

    private ICryptographyKey<?> createViaReflection(Class<? extends ICryptographyKey<?>> keyType, EKeyValidity keyValidity, EKeySource keySource) {
        try {
            return keyType.getConstructor(EKeyValidity.class, EKeySource.class).newInstance(new Object[]{keyValidity, keySource});
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown key type: " + keyType.getSimpleName(), e);
        }
    }

    private void sanityCheck(Class<?> keyType, EKeyValidity keyValidity, EKeySource keySource) {
        if (keyType == null) {
            throw new IllegalArgumentException("Key type must not be null.");
        }
        if (keyValidity == null) {
            throw new IllegalArgumentException("Key validity type must not be null.");
        }
        if (keySource == null) {
            throw new IllegalArgumentException("Key source type must not be null.");
        }
        if (keyValidity == EKeyValidity.VALID) {
            throw new IllegalArgumentException("Cannot create valid keys with this factory.");
        }
    }
}

