/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.visitor.extract;

import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Optional;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.mail.BaseMailCryptography;
import net.savignano.cryptography.mail.visitor.extract.IMailExtractor;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;

public abstract class AMailExtractor<T extends IPublicCryptographyKey<?>>
extends BaseMailCryptography
implements IMailExtractor<T> {
    protected AMailExtractor(Session session, ECryptographyType cryptography) {
        super(session, cryptography);
    }

    @Override
    public T extractPublicKey(MimeMessage msg) {
        T key;
        if (msg == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        Optional<String> email = MessageUtil.getFromEmail(msg);
        if (!email.isPresent()) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId((Message)msg);
        log.info("Extracing public key from message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            try {
                msg.writeTo((OutputStream)debugBaos);
                log.trace("Email:\n{}\n", (Object)debugBaos.toString());
            }
            catch (Exception e) {
                log.error("Could not log message. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            key = this.doExtract(msg, email.get());
        }
        catch (Exception e) {
            log.error("Could not extract public key from message with msg ID " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            key = this.getValidityKey(EKeyValidity.ERROR);
        }
        if (key == null) {
            key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.info("Finished extracing public key from message for {} with msg ID {}. Extracted key: {}", new Object[]{this.getCryptography(), msgId, key});
        return key;
    }

    protected abstract T doExtract(MimeMessage var1, String var2) throws Exception;

    protected abstract T getValidityKey(EKeyValidity var1);
}

