/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.snotify.atlassian.common.KeySourceComperator;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.mailer.keysource.IKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AKeyManager<T extends ICryptographyKey<?>, U>
implements IKeyManager<T, U> {
    private static final Logger log = LoggerFactory.getLogger(AKeyManager.class);
    private final ISnotifyAppProperties appProps;

    public AKeyManager(ISnotifyAppProperties appProps) {
        this.appProps = appProps;
    }

    @Override
    public T getKey(U forId) {
        boolean cacheStale;
        if (forId == null) {
            return this.getValidityKey(EKeyValidity.ERROR, EKeySource.UNKNOWN);
        }
        T cachedKey = this.getCachedKey(forId);
        log.debug("Cached key for \"{}\": {}", forId, cachedKey);
        boolean cacheAutoExpire = this.isCacheAutomaticallyExpired(forId);
        boolean cacheManualExpire = this.isCacheManuallyExpired(forId);
        boolean bl = cacheStale = cacheAutoExpire || cacheManualExpire;
        if (!cacheStale && this.isCachedKeyUsable(cachedKey, forId)) {
            log.debug("Cached key will be used.");
            return cachedKey;
        }
        T key = this.loadKey(forId);
        log.debug("Loaded key for \"{}\": {}", forId, key);
        if (!key.isValid() && cachedKey.isValid() && !cacheManualExpire && this.isCachedKeyUsable(cachedKey, forId)) {
            log.debug("Using cached key instead of loaded key.");
            key = cachedKey;
        }
        if (key != cachedKey && cacheStale && this.isKeyCachable(key, forId)) {
            log.debug("Storing of key is needed.");
            try {
                this.setCachedKey(forId, key.isValid() ? key : null);
            }
            catch (IOException e) {
                log.error("Key could not be stored. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return key;
    }

    private T loadKey(U forId) {
        List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<T, U>>>>> keyLoaders = this.getKeyLoaders();
        KeySourceComperator comperator = new KeySourceComperator();
        Collections.sort(keyLoaders, (e1, e2) -> comperator.compare((EKeySource)((Object)((Object)e1.getKey())), (EKeySource)((Object)((Object)e2.getKey()))));
        ICryptographyKey bestKey = null;
        for (Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<T, U>>>> entry : keyLoaders) {
            Supplier<Optional<IKeyLoader<T, U>>> loader = entry.getValue();
            T key = this.loadKey(entry.getKey(), loader, forId);
            if ((bestKey = this.chooseBetterKey(bestKey, key)).getKeyValidity() != EKeyValidity.VALID) continue;
            break;
        }
        if (bestKey == null) {
            bestKey = (ICryptographyKey)this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN);
        }
        return (T)bestKey;
    }

    private T loadKey(EKeySource source, Supplier<Optional<IKeyLoader<T, U>>> supplier, U forId) {
        Optional<IKeyLoader<T, U>> optional;
        try {
            optional = supplier.get();
        }
        catch (Exception e) {
            log.error("Unexpected error accessing " + String.valueOf((Object)source) + " source. Error message:" + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR, source);
        }
        if (!optional.isPresent()) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND, source);
        }
        IKeyLoader<T, U> loader = optional.get();
        try {
            log.debug("Loading key from location: {}", (Object)loader.getKeySource());
            return loader.loadKey(forId);
        }
        catch (Exception e) {
            log.error("Unexpected error retrieving key from: " + String.valueOf(loader) + ". Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR, loader.getKeySource());
        }
    }

    private T chooseBetterKey(T bestKey, T key) {
        if (bestKey == null) {
            return key;
        }
        if (key == null) {
            return bestKey;
        }
        if (key.getKeyValidity().compareTo(bestKey.getKeyValidity()) < 0) {
            return key;
        }
        return bestKey;
    }

    protected boolean isCacheAutomaticallyExpired(U forId) {
        return false;
    }

    protected boolean isCacheManuallyExpired(U forId) {
        return false;
    }

    protected boolean isCachedKeyUsable(T key, U forId) {
        return true;
    }

    protected boolean isKeyCachable(T key, U forId) {
        return key.getKeyValidity() != EKeyValidity.ERROR;
    }

    protected abstract T getCachedKey(U var1);

    protected abstract void setCachedKey(U var1, T var2) throws IOException;

    protected abstract List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<T, U>>>>> getKeyLoaders();

    protected abstract T getValidityKey(EKeyValidity var1, EKeySource var2);

    public ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }
}

