/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource;

import java.io.IOException;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APublicKeyManager<T extends IPublicCryptographyKey<?>, U extends IUser<?>>
extends AKeyManager<T, U> {
    private static final Logger log = LoggerFactory.getLogger(APublicKeyManager.class);
    public static final long EXPIRE_DURATION = 43200000L;
    private final ISnotifyUserProperties userProps;
    private final EProperty keyTimeStampProp;

    public APublicKeyManager(EProperty keyTimeStampProp, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(appProps);
        if (keyTimeStampProp == null) {
            throw new IllegalArgumentException("Time stamp propertie must not be null.");
        }
        if (appProps == null) {
            throw new IllegalArgumentException("Application properties must not be null.");
        }
        if (userProps == null) {
            throw new IllegalArgumentException("User properties must not be null.");
        }
        this.userProps = userProps;
        this.keyTimeStampProp = keyTimeStampProp;
    }

    @Override
    public T getKey(U user) {
        if (this.getAppProps().getBoolean(EProperty.LITE_MODE)) {
            log.debug("Loading key from user location, as light version is detected.");
            Object key = this.getCachedKey(user);
            if (key.getKeySource() != EKeySource.USER) {
                key = (IPublicCryptographyKey)this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.USER);
            }
            log.debug("User key for user {}: {}", user, key);
            return key;
        }
        return (T)((IPublicCryptographyKey)super.getKey(user));
    }

    @Override
    protected abstract T getCachedKey(U var1);

    @Override
    protected abstract void setCachedKey(U var1, T var2) throws IOException;

    @Override
    protected boolean isCacheAutomaticallyExpired(U user) {
        if (super.isCacheAutomaticallyExpired(user)) {
            return true;
        }
        if (!user.isActualUser()) {
            log.trace("No actual user given.");
            return true;
        }
        EKeySource keySource = this.getCachedKey(user).getKeySource();
        if (keySource == EKeySource.USER) {
            log.trace("User uploaded keys never expire automatically.");
            return false;
        }
        if (keySource == EKeySource.EMAIL) {
            log.trace("Email received keys never expire automatically.");
            return false;
        }
        Long cachedTimeStamp = this.getUserProps().getLong(this.keyTimeStampProp, (IUser<?>)user);
        if (cachedTimeStamp == null) {
            log.debug("Cache automatically expired: No cache timestamp.");
            return true;
        }
        if (System.currentTimeMillis() > cachedTimeStamp + 43200000L) {
            log.debug("Cache automatically expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCacheManuallyExpired(U user) {
        if (super.isCacheManuallyExpired(user)) {
            return true;
        }
        if (!user.isActualUser()) {
            log.trace("No actual user given.");
            return false;
        }
        EKeySource keySource = this.getCachedKey(user).getKeySource();
        if (keySource == EKeySource.USER) {
            log.trace("User uploaded keys never expire manually.");
            return false;
        }
        if (keySource == EKeySource.EMAIL) {
            log.trace("User uploaded keys never expire manually.");
            return false;
        }
        Long cachedTimeStamp = this.getUserProps().getLong(this.keyTimeStampProp, (IUser<?>)user);
        Long expireTimeStamp = this.getAppProps().getLong(EProperty.EXPIRE_KEYS_PUBLIC_TIMESTAMP);
        if (cachedTimeStamp != null && expireTimeStamp != null && expireTimeStamp > cachedTimeStamp) {
            log.debug("Cache manually expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCachedKeyUsable(T key, U user) {
        if (!super.isCachedKeyUsable(key, user)) {
            return false;
        }
        if (!user.isActualUser()) {
            log.debug("Not cachable: No actual user.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean isKeyCachable(T key, U user) {
        if (!super.isKeyCachable(key, user)) {
            return false;
        }
        if (!user.isActualUser()) {
            log.debug("Not cachable: No actual user.");
            return false;
        }
        if (key.getKeySource() == EKeySource.USER) {
            log.debug("Not cachable: User key.");
            return false;
        }
        return true;
    }

    public ISnotifyUserProperties getUserProps() {
        return this.userProps;
    }
}

