/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.common;

import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import io.atlassian.fugue.Option;
import java.util.function.Function;
import net.savignano.snotify.atlassian.common.properties.ASnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import org.springframework.beans.factory.annotation.Autowired;

@BitbucketComponent
public class SnotifyUserProperties
extends ASnotifyUserProperties {
    @ComponentImport
    private final UserSettingsService userSettingsService;
    @ComponentImport
    private final SecurityService securityService;

    @Autowired
    public SnotifyUserProperties(UserSettingsService userSettingsService, SecurityService securityService) {
        this.userSettingsService = userSettingsService;
        this.securityService = securityService;
    }

    @Override
    protected String get(String key, IUser<?> user) throws Exception {
        return (String)this.getProps(user, key).getOrNull();
    }

    @Override
    protected void set(String key, String value, IUser<?> user) throws Exception {
        this.updateProps(user, b -> b.put(key, value).build());
    }

    @Override
    protected void remove(String key, IUser<?> user) throws Exception {
        this.updateProps(user, b -> b.remove(key).build());
    }

    private Option<String> getProps(IUser<?> user, String key) {
        BitbucketUser bbUser = this.toBitbucketUser(user);
        EscalatedSecurityContext context = this.securityService.impersonating(bbUser.getActualUser(), "Getting user properties for: " + String.valueOf(bbUser));
        UserKey userKey = this.getUserKey(bbUser);
        UncheckedOperation operation = () -> this.userSettingsService.getUserSettings(userKey).getString(key);
        return (Option)context.call((Operation)operation);
    }

    private void updateProps(IUser<?> user, Function<UserSettingsBuilder, UserSettings> update) {
        BitbucketUser bbUser = this.toBitbucketUser(user);
        EscalatedSecurityContext context = this.securityService.impersonating(bbUser.getActualUser(), "Setting user properties for: " + String.valueOf(bbUser));
        UserKey userKey = this.getUserKey(bbUser);
        context.call(() -> {
            this.userSettingsService.updateUserSettings(userKey, update);
            return null;
        });
    }

    private UserKey getUserKey(BitbucketUser user) {
        return UserKey.fromLong((long)user.getActualUser().getId());
    }

    private BitbucketUser toBitbucketUser(IUser<?> user) {
        if (user == null) {
            throw new IllegalArgumentException("Can't get user preferences for 'null' user.");
        }
        if (!(user instanceof BitbucketUser)) {
            throw new IllegalArgumentException("User is not a BitbucketUser. Found instead: " + String.valueOf(user));
        }
        return (BitbucketUser)user;
    }
}

