/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.mailer;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.version.ProductInformation;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.enums.EEncryptionFailureBehavior;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyProjectProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailKeyExtractor;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailer;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpPublicKeyManager;
import net.savignano.snotify.bitbucket.common.BitbucketConstants;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import net.savignano.snotify.bitbucket.common.SnotifyI18n;
import net.savignano.snotify.bitbucket.mailer.IgnoreEncryptionDetector;
import net.savignano.snotify.bitbucket.mailer.keysource.smime.BitbucketSmimeKeyManager;
import net.savignano.snotify.bitbucket.mailer.util.MessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketMailer
extends AAtlassianMailer<BitbucketUser> {
    private static final Logger log = LoggerFactory.getLogger(BitbucketMailer.class);
    private static final String TICKET_REPLACEMENT = "%TICKET%";

    public BitbucketMailer(Session session, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps, ISnotifyProjectProperties projectProps) {
        super(session, appProps, userProps, projectProps);
    }

    @Override
    protected ProductInformation loadProductInformation() {
        return BitbucketConstants.PRODUCT_INFORMATION;
    }

    @Override
    protected MimeMessage getFailureMessage(MessageAndAddress msgAndAddress, EKeyValidity validity) throws MessagingException {
        Locale locale;
        BitbucketUser user = (BitbucketUser)this.getUser(msgAndAddress.address);
        I18nResolver i18nResolver = (I18nResolver)ComponentLocator.getComponent(I18nResolver.class);
        if (user != null) {
            log.debug("Getting locale for user: {}", (Object)user);
            applicationProperties = (ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class);
            locale = applicationProperties.getLocale();
        } else {
            log.debug("Getting default locale.");
            applicationProperties = (ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class);
            locale = applicationProperties.getLocale();
        }
        log.debug("Used locale for address \"{}\": {}", (Object)msgAndAddress.address, (Object)locale);
        SnotifyI18n i18n = new SnotifyI18n(i18nResolver, locale);
        MessageBuilder builder = new MessageBuilder((Message)msgAndAddress.message, i18n);
        builder.additional(this.getAppProps().getString(EProperty.TWEAK_REPORT_MESSAGE_ADDITIONAL_TEXT));
        builder.replace(this.getReplacementFailureMessage(msgAndAddress.address));
        if (this.getAppProps().getBoolean(EProperty.REPORT_MESSAGE_SHOW_LINK)) {
            // empty if block
        }
        if (validity == EKeyValidity.ERROR) {
            return builder.buildInternalErrorInfoMail();
        }
        EEncryptionTypePriority type = this.getTypePriority();
        builder.encryptionType(type);
        builder.editPgpInfo(this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE));
        builder.editSmimeInfo(this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE));
        return builder.buildMissingKeyInfoMail();
    }

    private String getReplacementFailureMessage(Address address) {
        if (this.isEmailBlocked(address) == EEncryptionFailureBehavior.REPORT && this.getAppProps().hasKey(EProperty.TWEAK_REPORT_MESSAGE_DOMAIN_BLOCK_TEXT)) {
            return this.getAppProps().getString(EProperty.TWEAK_REPORT_MESSAGE_DOMAIN_BLOCK_TEXT);
        }
        return this.getAppProps().getString(EProperty.TWEAK_REPORT_MESSAGE_REPLACE_TEXT);
    }

    @Override
    protected SmimeEncryptionKey getSmimeEncryptionKey(Address to) {
        IUser<?> user = this.virtualUser(to);
        BitbucketSmimeKeyManager manager = new BitbucketSmimeKeyManager(this.getAppProps(), this.getUserProps());
        return (SmimeEncryptionKey)manager.getKey(user);
    }

    @Override
    protected List<String> extractProjectKeys(MimeMessage msg) {
        return Collections.emptyList();
    }

    @Override
    protected List<BitbucketUser> getUsers(Address address) {
        return BitbucketUser.lookupUsers(address);
    }

    @Override
    protected boolean hasValidKey(BitbucketUser user, ECryptographyType cryptography) {
        switch (cryptography) {
            case NONE: {
                return false;
            }
            case PGP: {
                return ((PgpEncryptionKey)new PgpPublicKeyManager(this.getAppProps(), this.getUserProps()).getKey(user)).isValid();
            }
            case SMIME: {
                return ((SmimeEncryptionKey)new BitbucketSmimeKeyManager(this.getAppProps(), this.getUserProps()).getKey(user)).isValid();
            }
        }
        log.error("Unhandled cryptography: {}", (Object)cryptography);
        return false;
    }

    @Override
    protected boolean isEncryptionDesired(MessageAndAddress msgAndAddress) {
        if (!super.isEncryptionDesired(msgAndAddress)) {
            return false;
        }
        if (!this.isEncryptionDesiredWhitelistGroup(msgAndAddress)) {
            return false;
        }
        return this.isEncryptionDesiredPasswordResetMail(msgAndAddress);
    }

    private boolean isEncryptionDesiredWhitelistGroup(MessageAndAddress msgAndAddress) {
        BitbucketUser user;
        String whitelistUserGroup = this.getAppProps().getString(EProperty.WHITELIST_USER_GROUP);
        if (whitelistUserGroup != null && (user = (BitbucketUser)this.getUser(msgAndAddress.address)) != null) {
            UserService service = (UserService)ComponentLocator.getComponent(UserService.class);
            boolean member = service.isUserInGroup(user.getActualUser(), whitelistUserGroup);
            log.debug("User {} is in group {}: {}", new Object[]{user, whitelistUserGroup, member});
            return !member;
        }
        return true;
    }

    private boolean isEncryptionDesiredPasswordResetMail(MessageAndAddress msgAndAddress) {
        if (!this.getAppProps().getBoolean(EProperty.ALLOW_PASSWORD_RESET_MAIL)) {
            return true;
        }
        boolean ignoreEncryption = new IgnoreEncryptionDetector(this.getBaseUrl()).isIgnoreEncryptionEmail(msgAndAddress.message);
        log.debug("Message with ID \"{}\" is considered a 'password reset email': {}", (Object)MessageUtil.getMessageId((Message)msgAndAddress.message), (Object)ignoreEncryption);
        return !ignoreEncryption;
    }

    @Override
    protected String getSubjectReplacement(MimeMessage msg) {
        Object replacement = super.getSubjectReplacement(msg);
        if (replacement != null && this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION_KEEP_ID)) {
            if (this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_REPLACEMENT) == null) {
                replacement = "(%TICKET%) " + (String)replacement;
            }
            log.debug("Subject replacement pattern: {}", replacement);
            replacement = this.replaceTicket(msg, (String)replacement);
            replacement = ((String)replacement).replace(" ()", "");
        }
        return replacement;
    }

    private String replaceTicket(MimeMessage msg, String replacement) {
        int index = replacement.indexOf(TICKET_REPLACEMENT);
        if (index == -1) {
            return replacement;
        }
        log.debug("Extracting primary issue key.");
        String baseUrl = this.getBaseUrl();
        String issueId = this.getSubjectIssue(msg, baseUrl);
        return replacement.replace(TICKET_REPLACEMENT, issueId == null ? "" : issueId);
    }

    private String getSubjectIssue(MimeMessage msg, String baseUrl) {
        AAtlassianMailKeyExtractor extractor = null;
        List<String> keys = this.extractKeys(msg, extractor);
        String subject = null;
        try {
            subject = msg.getSubject();
        }
        catch (MessagingException e) {
            log.error("Could not get subject from email. Error message: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Looking for issue reference in subject: {}", (Object)subject);
        String issueId = null;
        if (subject != null) {
            for (String key : keys) {
                if (!subject.contains(key)) continue;
                issueId = key;
                break;
            }
        }
        log.debug("Issue ID from subject: {}", issueId);
        return issueId;
    }

    private List<String> extractKeys(MimeMessage msg, AAtlassianMailKeyExtractor extractor) {
        Set<String> keys;
        String msgId = MessageUtil.getMessageId((Message)msg);
        try {
            keys = extractor.getKeys(msg);
        }
        catch (Exception e) {
            log.error("Could not extract keys for message with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            keys = Collections.emptySet();
        }
        log.debug("Reference(s) found in message with ID \"{}\": {}", (Object)msgId, keys);
        return new ArrayList<String>(keys);
    }

    private String getBaseUrl() {
        ApplicationPropertiesService bitbucketProps = (ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class);
        return bitbucketProps.getBaseUrl().toString();
    }
}

