/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGObject;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public abstract class OctetArrayBCPGKey
extends BCPGObject
implements BCPGKey {
    private final byte[] key;

    OctetArrayBCPGKey(int length, BCPGInputStream in) throws IOException {
        this.key = new byte[length];
        in.readFully(this.key);
    }

    OctetArrayBCPGKey(int length, byte[] key) {
        if (key.length != length) {
            throw new IllegalArgumentException("unexpected key encoding length: expected " + length + " bytes, got " + key.length);
        }
        this.key = new byte[length];
        System.arraycopy(key, 0, this.key, 0, length);
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.write(this.key);
    }

    public byte[] getKey() {
        return Arrays.clone(this.key);
    }
}

