/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetStringParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1SequenceParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1SetParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.AttributeTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.AuthEnvelopedDataParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.CMSAttributes;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.EncryptedContentInfoParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.OriginatorInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSContentInfoParser;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSEnvelopedHelper;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSProcessableInputStream;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSecureReadableWithAAD;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSUtils;
import net.savignano.thirdparty.org.bouncycastle.cms.InputStreamWithMAC;
import net.savignano.thirdparty.org.bouncycastle.cms.MACProvider;
import net.savignano.thirdparty.org.bouncycastle.cms.OriginatorInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformationStore;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class CMSAuthEnvelopedDataParser
extends CMSContentInfoParser {
    private final RecipientInformationStore recipientInfoStore;
    private final AuthEnvelopedDataParser authEvnData = new AuthEnvelopedDataParser((ASN1SequenceParser)this._contentInfo.getContent(16));
    private final LocalMacProvider localMacProvider;
    private final AlgorithmIdentifier encAlg;
    private AttributeTable authAttrs;
    private ASN1Set authAttrSet;
    private AttributeTable unauthAttrs;
    private boolean authAttrNotRead = true;
    private boolean unauthAttrNotRead = true;
    private OriginatorInformation originatorInfo;

    public CMSAuthEnvelopedDataParser(byte[] envelopedData) throws CMSException, IOException {
        this(new ByteArrayInputStream(envelopedData));
    }

    public CMSAuthEnvelopedDataParser(InputStream envelopedData) throws CMSException, IOException {
        super(envelopedData);
        OriginatorInfo info = this.authEvnData.getOriginatorInfo();
        if (info != null) {
            this.originatorInfo = new OriginatorInformation(info);
        }
        ASN1Set recipientInfos = ASN1Set.getInstance(this.authEvnData.getRecipientInfos().toASN1Primitive());
        final EncryptedContentInfoParser encInfo = this.authEvnData.getAuthEncryptedContentInfo();
        this.encAlg = encInfo.getContentEncryptionAlgorithm();
        this.localMacProvider = new LocalMacProvider(this.authEvnData, this);
        final CMSProcessableInputStream readable = new CMSProcessableInputStream(new InputStreamWithMAC(((ASN1OctetStringParser)encInfo.getEncryptedContent(4)).getOctetStream(), this.localMacProvider));
        CMSSecureReadableWithAAD secureReadable = new CMSSecureReadableWithAAD(){
            private OutputStream aadStream;

            @Override
            public ASN1ObjectIdentifier getContentType() {
                return encInfo.getContentType();
            }

            @Override
            public InputStream getInputStream() throws IOException, CMSException {
                return readable.getInputStream();
            }

            @Override
            public ASN1Set getAuthAttrSet() {
                return CMSAuthEnvelopedDataParser.this.authAttrSet;
            }

            @Override
            public void setAuthAttrSet(ASN1Set set) {
            }

            @Override
            public boolean hasAdditionalData() {
                return true;
            }

            @Override
            public void setAADStream(OutputStream stream) {
                this.aadStream = stream;
            }

            @Override
            public OutputStream getAADStream() {
                return this.aadStream;
            }

            @Override
            public byte[] getMAC() {
                return Arrays.clone(CMSAuthEnvelopedDataParser.this.localMacProvider.getMAC());
            }
        };
        this.localMacProvider.setSecureReadable(secureReadable);
        this.recipientInfoStore = CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, this.encAlg, secureReadable);
    }

    public OriginatorInformation getOriginatorInfo() {
        return this.originatorInfo;
    }

    public AlgorithmIdentifier getEncryptionAlgOID() {
        return this.encAlg;
    }

    public String getEncAlgOID() {
        return this.encAlg.getAlgorithm().toString();
    }

    public byte[] getEncAlgParams() {
        try {
            return CMSUtils.encodeObj(this.encAlg.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encryption parameters " + e);
        }
    }

    public RecipientInformationStore getRecipientInfos() {
        return this.recipientInfoStore;
    }

    public byte[] getMac() throws IOException {
        return Arrays.clone(this.localMacProvider.getMAC());
    }

    private ASN1Set getAuthAttrSet() throws IOException {
        if (this.authAttrs == null && this.authAttrNotRead) {
            ASN1SetParser set = this.authEvnData.getAuthAttrs();
            if (set != null) {
                this.authAttrSet = (ASN1Set)set.toASN1Primitive();
            }
            this.authAttrNotRead = false;
        }
        return this.authAttrSet;
    }

    public AttributeTable getAuthAttrs() throws IOException {
        ASN1Set set;
        if (this.authAttrs == null && this.authAttrNotRead && (set = this.getAuthAttrSet()) != null) {
            this.authAttrs = new AttributeTable(set);
        }
        return this.authAttrs;
    }

    public AttributeTable getUnauthAttrs() throws IOException {
        if (this.unauthAttrs == null && this.unauthAttrNotRead) {
            this.unauthAttrNotRead = false;
            this.unauthAttrs = CMSUtils.getAttributesTable(this.authEvnData.getUnauthAttrs());
        }
        return this.unauthAttrs;
    }

    public byte[] getContentDigest() {
        if (this.authAttrs != null) {
            return ASN1OctetString.getInstance(this.authAttrs.get(CMSAttributes.messageDigest).getAttrValues().getObjectAt(0)).getOctets();
        }
        return null;
    }

    static class LocalMacProvider
    implements MACProvider {
        private byte[] mac;
        private final AuthEnvelopedDataParser authEnvData;
        private final CMSAuthEnvelopedDataParser parser;
        private CMSSecureReadableWithAAD readable;

        LocalMacProvider(AuthEnvelopedDataParser authEnvData, CMSAuthEnvelopedDataParser parser) {
            this.authEnvData = authEnvData;
            this.parser = parser;
        }

        @Override
        public void init() throws IOException {
            this.parser.authAttrs = this.parser.getAuthAttrs();
            if (this.parser.authAttrs != null) {
                this.readable.setAuthAttrSet(this.parser.authAttrSet);
                this.readable.getAADStream().write(this.parser.authAttrs.toASN1Structure().getEncoded("DER"));
            }
            this.mac = this.authEnvData.getMac().getOctets();
        }

        void setSecureReadable(CMSSecureReadableWithAAD secureReadable) {
            this.readable = secureReadable;
        }

        @Override
        public byte[] getMAC() {
            return this.mac;
        }
    }
}

