/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms.jcajce;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAttributeTableGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignatureEncryptionAlgorithmFinder;
import net.savignano.thirdparty.org.bouncycastle.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInfoGeneratorBuilder;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentSigner;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;

public class JcaSignerInfoGeneratorBuilder {
    private SignerInfoGeneratorBuilder builder;

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider) {
        this(digestProvider, new DefaultCMSSignatureEncryptionAlgorithmFinder());
    }

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider, CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder) {
        this.builder = new SignerInfoGeneratorBuilder(digestProvider, sigEncAlgFinder);
    }

    public JcaSignerInfoGeneratorBuilder setDirectSignature(boolean hasNoSignedAttributes) {
        this.builder.setDirectSignature(hasNoSignedAttributes);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setContentDigest(AlgorithmIdentifier contentDigest) {
        this.builder.setContentDigest(contentDigest);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator signedGen) {
        this.builder.setSignedAttributeGenerator(signedGen);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator unsignedGen) {
        this.builder.setUnsignedAttributeGenerator(unsignedGen);
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder certHolder) throws OperatorCreationException {
        return this.builder.build(contentSigner, certHolder);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] keyIdentifier) throws OperatorCreationException {
        return this.builder.build(contentSigner, keyIdentifier);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509Certificate certificate) throws OperatorCreationException, CertificateEncodingException {
        return this.build(contentSigner, new JcaX509CertificateHolder(certificate));
    }
}

