/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificate;
import net.savignano.thirdparty.org.bouncycastle.its.ITSCertificateBuilder;
import net.savignano.thirdparty.org.bouncycastle.its.ITSPublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.its.ITSPublicVerificationKey;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ECDSAEncoder;
import net.savignano.thirdparty.org.bouncycastle.its.operator.ITSContentSigner;
import net.savignano.thirdparty.org.bouncycastle.oer.OEREncoder;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.CertificateBase;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.CertificateId;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.CertificateType;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.IssuerIdentifier;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.ToBeSignedCertificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.VerificationKeyIndicator;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.HashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.HashedId8;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.Signature;
import net.savignano.thirdparty.org.bouncycastle.oer.its.template.ieee1609dot2.IEEE1609dot2;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class ITSExplicitCertificateBuilder
extends ITSCertificateBuilder {
    private final ITSContentSigner signer;

    public ITSExplicitCertificateBuilder(ITSContentSigner signer, ToBeSignedCertificate.Builder tbsCertificate) {
        super(tbsCertificate);
        this.signer = signer;
    }

    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey verificationKey) {
        return this.build(certificateId, verificationKey, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITSCertificate build(CertificateId certificateId, ITSPublicVerificationKey verificationKey, ITSPublicEncryptionKey publicEncryptionKey) {
        IssuerIdentifier issuerIdentifier;
        VerificationKeyIndicator verificationKeyIndicator;
        ToBeSignedCertificate.Builder tbsBldr = new ToBeSignedCertificate.Builder(this.tbsCertificateBuilder);
        tbsBldr.setId(certificateId);
        if (publicEncryptionKey != null) {
            tbsBldr.setEncryptionKey(publicEncryptionKey.toASN1Structure());
        }
        tbsBldr.setVerifyKeyIndicator(VerificationKeyIndicator.verificationKey(verificationKey.toASN1Structure()));
        ToBeSignedCertificate tbsCertificate = tbsBldr.createToBeSignedCertificate();
        ToBeSignedCertificate signerCert = null;
        if (this.signer.isForSelfSigning()) {
            verificationKeyIndicator = tbsCertificate.getVerifyKeyIndicator();
        } else {
            signerCert = this.signer.getAssociatedCertificate().toASN1Structure().getToBeSigned();
            verificationKeyIndicator = signerCert.getVerifyKeyIndicator();
        }
        OutputStream sOut = this.signer.getOutputStream();
        try {
            sOut.write(OEREncoder.toByteArray(tbsCertificate, IEEE1609dot2.ToBeSignedCertificate.build()));
            sOut.close();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot produce certificate signature");
        }
        Signature sig = null;
        switch (verificationKeyIndicator.getChoice()) {
            case 0: {
                sig = ECDSAEncoder.toITS(SECObjectIdentifiers.secp256r1, this.signer.getSignature());
                break;
            }
            case 1: {
                sig = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP256r1, this.signer.getSignature());
                break;
            }
            case 2: {
                sig = ECDSAEncoder.toITS(TeleTrusTObjectIdentifiers.brainpoolP384r1, this.signer.getSignature());
                break;
            }
            default: {
                throw new IllegalStateException("unknown key type");
            }
        }
        CertificateBase.Builder baseBldr = new CertificateBase.Builder();
        ASN1ObjectIdentifier digestAlg = this.signer.getDigestAlgorithm().getAlgorithm();
        if (this.signer.isForSelfSigning()) {
            if (digestAlg.equals(NISTObjectIdentifiers.id_sha256)) {
                issuerIdentifier = IssuerIdentifier.self(HashAlgorithm.sha256);
            } else {
                if (!digestAlg.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                issuerIdentifier = IssuerIdentifier.self(HashAlgorithm.sha384);
            }
        } else {
            byte[] parentDigest = this.signer.getAssociatedCertificateDigest();
            HashedId8 hashedID = new HashedId8(Arrays.copyOfRange(parentDigest, parentDigest.length - 8, parentDigest.length));
            if (digestAlg.equals(NISTObjectIdentifiers.id_sha256)) {
                issuerIdentifier = IssuerIdentifier.sha256AndDigest(hashedID);
            } else {
                if (!digestAlg.equals(NISTObjectIdentifiers.id_sha384)) throw new IllegalStateException("unknown digest");
                issuerIdentifier = IssuerIdentifier.sha384AndDigest(hashedID);
            }
        }
        baseBldr.setVersion(this.version);
        baseBldr.setType(CertificateType.explicit);
        baseBldr.setIssuer(issuerIdentifier);
        baseBldr.setToBeSigned(tbsCertificate);
        baseBldr.setSignature(sig);
        return new ITSCertificate(baseBldr.createCertificateBase());
    }
}

