/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADUtils;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA256Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.HKDFParameters;

class AEADUtil {
    AEADUtil() {
    }

    static byte[] deriveMessageKeyAndIv(int aeadAlgo, int cipherAlgo, byte[] sessionKey, byte[] salt, byte[] hkdfInfo) {
        HKDFParameters hkdfParameters = new HKDFParameters(sessionKey, salt, hkdfInfo);
        HKDFBytesGenerator hkdfGen = new HKDFBytesGenerator(new SHA256Digest());
        hkdfGen.init(hkdfParameters);
        int keyLen = SymmetricKeyUtils.getKeyLengthInOctets(cipherAlgo);
        int ivLen = AEADUtils.getIVLength(aeadAlgo);
        byte[] messageKeyAndIv = new byte[keyLen + ivLen - 8];
        hkdfGen.generateBytes(messageKeyAndIv, 0, messageKeyAndIv.length);
        return messageKeyAndIv;
    }
}

