/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import net.savignano.thirdparty.org.bouncycastle.jcajce.io.OutputStreamFactory;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPRuntimeOperationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentSigner;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import net.savignano.thirdparty.org.bouncycastle.util.io.TeeOutputStream;

public class JcaPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public JcaPGPContentSignerBuilder(int keyAlgorithm, int hashAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
    }

    public JcaPGPContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JcaPGPContentSignerBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentSignerBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        this.digestCalculatorProviderBuilder.setProvider(providerName);
        return this;
    }

    public JcaPGPContentSignerBuilder setDigestProvider(Provider provider) {
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentSignerBuilder setDigestProvider(String providerName) {
        this.digestCalculatorProviderBuilder.setProvider(providerName);
        return this;
    }

    @Override
    public PGPContentSigner build(int signatureType, PGPPrivateKey privateKey) throws PGPException {
        if (privateKey instanceof JcaPGPPrivateKey) {
            return this.build(signatureType, privateKey.getKeyID(), ((JcaPGPPrivateKey)privateKey).getPrivateKey());
        }
        return this.build(signatureType, privateKey.getKeyID(), this.keyConverter.getPrivateKey(privateKey));
    }

    public PGPContentSigner build(final int signatureType, final long keyID, PrivateKey privateKey) throws PGPException {
        final PGPDigestCalculator digestCalculator = this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
        final PGPDigestCalculator edDigestCalculator = this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
        final Signature signature = this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
        try {
            if (this.random != null) {
                signature.initSign(privateKey, this.random);
            } else {
                signature.initSign(privateKey);
            }
        }
        catch (InvalidKeyException e) {
            throw new PGPException("invalid key.", e);
        }
        return new PGPContentSigner(){
            private final boolean isEdDsa;
            {
                this.isEdDsa = JcaPGPContentSignerBuilder.this.keyAlgorithm == 22 || JcaPGPContentSignerBuilder.this.keyAlgorithm == 28 || JcaPGPContentSignerBuilder.this.keyAlgorithm == 27;
            }

            @Override
            public int getType() {
                return signatureType;
            }

            @Override
            public int getHashAlgorithm() {
                return JcaPGPContentSignerBuilder.this.hashAlgorithm;
            }

            @Override
            public int getKeyAlgorithm() {
                return JcaPGPContentSignerBuilder.this.keyAlgorithm;
            }

            @Override
            public long getKeyID() {
                return keyID;
            }

            @Override
            public OutputStream getOutputStream() {
                if (this.isEdDsa) {
                    return new TeeOutputStream(edDigestCalculator.getOutputStream(), digestCalculator.getOutputStream());
                }
                return new TeeOutputStream(OutputStreamFactory.createStream(signature), digestCalculator.getOutputStream());
            }

            @Override
            public byte[] getSignature() {
                try {
                    if (this.isEdDsa) {
                        signature.update(edDigestCalculator.getDigest());
                    }
                    return signature.sign();
                }
                catch (SignatureException e) {
                    throw new PGPRuntimeOperationException("Unable to create signature: " + e.getMessage(), e);
                }
            }

            @Override
            public byte[] getDigest() {
                return digestCalculator.getDigest();
            }
        };
    }
}

