/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openssl.jcajce;

import java.security.Provider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMDecryptorProvider;
import net.savignano.thirdparty.org.bouncycastle.openssl.PEMException;
import net.savignano.thirdparty.org.bouncycastle.openssl.PasswordException;
import net.savignano.thirdparty.org.bouncycastle.openssl.jcajce.PEMUtilities;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public PEMDecryptorProvider build(final char[] password) {
        return new PEMDecryptorProvider(){

            @Override
            public PEMDecryptor get(final String dekAlgName) {
                return new PEMDecryptor(){

                    @Override
                    public byte[] decrypt(byte[] keyBytes, byte[] iv) throws PEMException {
                        if (password == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, keyBytes, password, dekAlgName, iv);
                    }
                };
            }
        };
    }
}

