/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.sphincsplus;

import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

class HarakaSBase {
    protected long[][] haraka512_rc = new long[][]{{2652350495371256459L, -4767360454786055294L, -2778808723033108313L, -6138960262205972599L, 4944264682582508575L, 5312892415214084856L, 390034814247088728L, 2584105839607850161L}, {-2829930801980875922L, 9137660425067592590L, 7974068014816832049L, -4665944065725157058L, 2602240152241800734L, -1525694355931290902L, 8634660511727056099L, 1757945485816280992L}, {1181946526362588450L, -2765192619992380293L, 3395396416743122529L, -5116273100549372423L, -1285454309797503998L, -3363297609815171261L, -8360835858392998991L, -2371352336613968487L}, {-2500853454776756032L, 8465221333286591414L, 8817016078209461823L, 9067727467981428858L, 4244107674518258433L, -4347326460570889538L, 1711371409274742987L, 6486926172609168623L}, {1689001080716996467L, -491496126278250673L, 1273395568185090836L, 5805238412293617850L, -3441289770925384855L, 4592753210857527691L, 7062886034259989751L, -7974393977033172556L}, {-797818098819718290L, -41460260651793472L, 476036171179798187L, 7391697506481003962L, -855662275170689475L, -3489340839585811635L, -4891525734487956488L, 9110006695579921767L}, {-886938081943560790L, 4212830408327159617L, -3546674487567282635L, -1955379422127038289L, 3174578079917510314L, 5156046680874954380L, -318545805834821831L, -6176414008149462342L}, {2529785914229181047L, 2966313764524854080L, 6363694428402697361L, 8292109690175819701L, -8497546332135459587L, -3211108476154815616L, -5526938793786642321L, -4975969843627057770L}, {3357847021085574721L, -4764837212565187058L, -626391829400648692L, 2124133995575340009L, 7425858999829294301L, -3432032868905637771L, 1119301198758921294L, 1907812968586478892L}, {-8986524826712832802L, 3356175496741300052L, -5764600317639896362L, 4002747967109689317L, -8718925159733497197L, -1938063772587374661L, -8003749789895945835L, 7302960353763723932L}};
    protected int[][] haraka256_rc = new int[10][8];
    protected final byte[] buffer = new byte[64];
    protected int off = 0;

    protected HarakaSBase() {
    }

    protected void reset() {
        this.off = 0;
        Arrays.clear(this.buffer);
    }

    private void brRangeDec32Le(byte[] input, int[] output, int inputPos) {
        for (int i = 0; i < output.length; ++i) {
            int tmp = inputPos + (i << 2);
            output[i] = input[tmp] & 0xFF | input[tmp + 1] << 8 & 0xFF00 | input[tmp + 2] << 16 & 0xFF0000 | input[tmp + 3] << 24;
        }
    }

    protected void interleaveConstant(long[] output, byte[] input, int startPos) {
        int[] tmp_32_constant = new int[16];
        this.brRangeDec32Le(input, tmp_32_constant, startPos);
        for (int i = 0; i < 4; ++i) {
            this.brAesCt64InterleaveIn(output, i, tmp_32_constant, i << 2);
        }
        this.brAesCt64Ortho(output);
    }

    protected void interleaveConstant32(int[] output, byte[] input, int startPos) {
        for (int i = 0; i < 4; ++i) {
            output[i << 1] = this.brDec32Le(input, startPos + (i << 2));
            output[(i << 1) + 1] = this.brDec32Le(input, startPos + (i << 2) + 16);
        }
        this.brAesCtOrtho(output);
    }

    private int brDec32Le(byte[] input, int startPos) {
        return input[startPos] & 0xFF | input[startPos + 1] << 8 & 0xFF00 | input[startPos + 2] << 16 & 0xFF0000 | input[startPos + 3] << 24;
    }

    protected void haraka512Perm(byte[] output) {
        int j;
        int i;
        int[] w = new int[16];
        long[] q = new long[8];
        this.brRangeDec32Le(this.buffer, w, 0);
        for (i = 0; i < 4; ++i) {
            this.brAesCt64InterleaveIn(q, i, w, i << 2);
        }
        this.brAesCt64Ortho(q);
        for (i = 0; i < 5; ++i) {
            for (j = 0; j < 2; ++j) {
                this.brAesCt64BitsliceSbox(q);
                this.shiftRows(q);
                this.mixColumns(q);
                this.addRoundKey(q, this.haraka512_rc[(i << 1) + j]);
            }
            for (j = 0; j < 8; ++j) {
                long tmp_q = q[j];
                q[j] = (tmp_q & 0x1000100010001L) << 5 | (tmp_q & 0x2000200020002L) << 12 | (tmp_q & 0x4000400040004L) >>> 1 | (tmp_q & 0x8000800080008L) << 6 | (tmp_q & 0x20002000200020L) << 9 | (tmp_q & 0x40004000400040L) >>> 4 | (tmp_q & 0x80008000800080L) << 3 | (tmp_q & 0x2100210021002100L) >>> 5 | (tmp_q & 0x210021002100210L) << 2 | (tmp_q & 0x800080008000800L) << 4 | (tmp_q & 0x1000100010001000L) >>> 12 | (tmp_q & 0x4000400040004000L) >>> 10 | (tmp_q & 0x8400840084008400L) >>> 3;
            }
        }
        this.brAesCt64Ortho(q);
        for (i = 0; i < 4; ++i) {
            this.brAesCt64InterleaveOut(w, q, i);
        }
        for (i = 0; i < 16; ++i) {
            for (j = 0; j < 4; ++j) {
                output[(i << 2) + j] = (byte)(w[i] >>> (j << 3) & 0xFF);
            }
        }
    }

    protected void haraka256Perm(byte[] output) {
        int i;
        int[] q = new int[8];
        this.interleaveConstant32(q, this.buffer, 0);
        for (i = 0; i < 5; ++i) {
            int j;
            for (j = 0; j < 2; ++j) {
                HarakaSBase.brAesCtBitsliceSbox(q);
                this.shiftRows32(q);
                this.mixColumns32(q);
                this.addRoundKey32(q, this.haraka256_rc[(i << 1) + j]);
            }
            for (j = 0; j < 8; ++j) {
                int tmp_q = q[j];
                q[j] = tmp_q & 0x81818181 | (tmp_q & 0x2020202) << 1 | (tmp_q & 0x4040404) << 2 | (tmp_q & 0x8080808) << 3 | (tmp_q & 0x10101010) >>> 3 | (tmp_q & 0x20202020) >>> 2 | (tmp_q & 0x40404040) >>> 1;
            }
        }
        this.brAesCtOrtho(q);
        for (i = 0; i < 4; ++i) {
            this.brEnc32Le(output, q[i << 1], i << 2);
            this.brEnc32Le(output, q[(i << 1) + 1], (i << 2) + 16);
        }
    }

    private void brEnc32Le(byte[] dst, int x, int startPos) {
        for (int i = 0; i < 4; ++i) {
            dst[startPos + i] = (byte)(x >> (i << 3));
        }
    }

    private void brAesCt64InterleaveIn(long[] q, int qPos, int[] w, int startPos) {
        long x0 = (long)w[startPos] & 0xFFFFFFFFL;
        long x1 = (long)w[startPos + 1] & 0xFFFFFFFFL;
        long x2 = (long)w[startPos + 2] & 0xFFFFFFFFL;
        long x3 = (long)w[startPos + 3] & 0xFFFFFFFFL;
        x0 |= x0 << 16;
        x1 |= x1 << 16;
        x2 |= x2 << 16;
        x3 |= x3 << 16;
        x0 &= 0xFFFF0000FFFFL;
        x1 &= 0xFFFF0000FFFFL;
        x2 &= 0xFFFF0000FFFFL;
        x3 &= 0xFFFF0000FFFFL;
        x0 |= x0 << 8;
        x1 |= x1 << 8;
        x2 |= x2 << 8;
        x3 |= x3 << 8;
        q[qPos] = (x0 &= 0xFF00FF00FF00FFL) | (x2 &= 0xFF00FF00FF00FFL) << 8;
        q[qPos + 4] = (x1 &= 0xFF00FF00FF00FFL) | (x3 &= 0xFF00FF00FF00FFL) << 8;
    }

    private static void brAesCtBitsliceSbox(int[] q) {
        int x0 = q[7];
        int x1 = q[6];
        int x2 = q[5];
        int x3 = q[4];
        int x4 = q[3];
        int x5 = q[2];
        int x6 = q[1];
        int x7 = q[0];
        int y14 = x3 ^ x5;
        int y13 = x0 ^ x6;
        int y9 = x0 ^ x3;
        int y8 = x0 ^ x5;
        int t0 = x1 ^ x2;
        int y1 = t0 ^ x7;
        int y4 = y1 ^ x3;
        int y12 = y13 ^ y14;
        int y2 = y1 ^ x0;
        int y5 = y1 ^ x6;
        int y3 = y5 ^ y8;
        int t1 = x4 ^ y12;
        int y15 = t1 ^ x5;
        int y20 = t1 ^ x1;
        int y6 = y15 ^ x7;
        int y10 = y15 ^ t0;
        int y11 = y20 ^ y9;
        int y7 = x7 ^ y11;
        int y17 = y10 ^ y11;
        int y19 = y10 ^ y8;
        int y16 = t0 ^ y11;
        int y21 = y13 ^ y16;
        int y18 = x0 ^ y16;
        int t2 = y12 & y15;
        int t3 = y3 & y6;
        int t4 = t3 ^ t2;
        int t5 = y4 & x7;
        int t6 = t5 ^ t2;
        int t7 = y13 & y16;
        int t8 = y5 & y1;
        int t9 = t8 ^ t7;
        int t10 = y2 & y7;
        int t11 = t10 ^ t7;
        int t12 = y9 & y11;
        int t13 = y14 & y17;
        int t14 = t13 ^ t12;
        int t15 = y8 & y10;
        int t16 = t15 ^ t12;
        int t17 = t4 ^ t14;
        int t18 = t6 ^ t16;
        int t19 = t9 ^ t14;
        int t20 = t11 ^ t16;
        int t21 = t17 ^ y20;
        int t22 = t18 ^ y19;
        int t23 = t19 ^ y21;
        int t24 = t20 ^ y18;
        int t25 = t21 ^ t22;
        int t26 = t21 & t23;
        int t27 = t24 ^ t26;
        int t28 = t25 & t27;
        int t29 = t28 ^ t22;
        int t30 = t23 ^ t24;
        int t31 = t22 ^ t26;
        int t32 = t31 & t30;
        int t33 = t32 ^ t24;
        int t34 = t23 ^ t33;
        int t35 = t27 ^ t33;
        int t36 = t24 & t35;
        int t37 = t36 ^ t34;
        int t38 = t27 ^ t36;
        int t39 = t29 & t38;
        int t40 = t25 ^ t39;
        int t41 = t40 ^ t37;
        int t42 = t29 ^ t33;
        int t43 = t29 ^ t40;
        int t44 = t33 ^ t37;
        int t45 = t42 ^ t41;
        int z0 = t44 & y15;
        int z1 = t37 & y6;
        int z2 = t33 & x7;
        int z3 = t43 & y16;
        int z4 = t40 & y1;
        int z5 = t29 & y7;
        int z6 = t42 & y11;
        int z7 = t45 & y17;
        int z8 = t41 & y10;
        int z9 = t44 & y12;
        int z10 = t37 & y3;
        int z11 = t33 & y4;
        int z12 = t43 & y13;
        int z13 = t40 & y5;
        int z14 = t29 & y2;
        int z15 = t42 & y9;
        int z16 = t45 & y14;
        int z17 = t41 & y8;
        int t46 = z15 ^ z16;
        int t47 = z10 ^ z11;
        int t48 = z5 ^ z13;
        int t49 = z9 ^ z10;
        int t50 = z2 ^ z12;
        int t51 = z2 ^ z5;
        int t52 = z7 ^ z8;
        int t53 = z0 ^ z3;
        int t54 = z6 ^ z7;
        int t55 = z16 ^ z17;
        int t56 = z12 ^ t48;
        int t57 = t50 ^ t53;
        int t58 = z4 ^ t46;
        int t59 = z3 ^ t54;
        int t60 = t46 ^ t57;
        int t61 = z14 ^ t57;
        int t62 = t52 ^ t58;
        int t63 = t49 ^ t58;
        int t64 = z4 ^ t59;
        int t65 = t61 ^ t62;
        int t66 = z1 ^ t63;
        int s0 = t59 ^ t63;
        int s6 = t56 ^ ~t62;
        int s7 = t48 ^ ~t60;
        int t67 = t64 ^ t65;
        int s3 = t53 ^ t66;
        int s4 = t51 ^ t66;
        int s5 = t47 ^ t65;
        int s1 = t64 ^ ~s3;
        int s2 = t55 ^ ~t67;
        q[7] = s0;
        q[6] = s1;
        q[5] = s2;
        q[4] = s3;
        q[3] = s4;
        q[2] = s5;
        q[1] = s6;
        q[0] = s7;
    }

    private void shiftRows32(int[] q) {
        for (int i = 0; i < 8; ++i) {
            int x = q[i];
            q[i] = x & 0xFF | (x & 0xFC00) >>> 2 | (x & 0x300) << 6 | (x & 0xF00000) >>> 4 | (x & 0xF0000) << 4 | (x & 0xC0000000) >>> 6 | (x & 0x3F000000) << 2;
        }
    }

    private void mixColumns32(int[] q) {
        int q0 = q[0];
        int q1 = q[1];
        int q2 = q[2];
        int q3 = q[3];
        int q4 = q[4];
        int q5 = q[5];
        int q6 = q[6];
        int q7 = q[7];
        int r0 = q0 >>> 8 | q0 << 24;
        int r1 = q1 >>> 8 | q1 << 24;
        int r2 = q2 >>> 8 | q2 << 24;
        int r3 = q3 >>> 8 | q3 << 24;
        int r4 = q4 >>> 8 | q4 << 24;
        int r5 = q5 >>> 8 | q5 << 24;
        int r6 = q6 >>> 8 | q6 << 24;
        int r7 = q7 >>> 8 | q7 << 24;
        q[0] = q7 ^ r7 ^ r0 ^ this.rotr16(q0 ^ r0);
        q[1] = q0 ^ r0 ^ q7 ^ r7 ^ r1 ^ this.rotr16(q1 ^ r1);
        q[2] = q1 ^ r1 ^ r2 ^ this.rotr16(q2 ^ r2);
        q[3] = q2 ^ r2 ^ q7 ^ r7 ^ r3 ^ this.rotr16(q3 ^ r3);
        q[4] = q3 ^ r3 ^ q7 ^ r7 ^ r4 ^ this.rotr16(q4 ^ r4);
        q[5] = q4 ^ r4 ^ r5 ^ this.rotr16(q5 ^ r5);
        q[6] = q5 ^ r5 ^ r6 ^ this.rotr16(q6 ^ r6);
        q[7] = q6 ^ r6 ^ r7 ^ this.rotr16(q7 ^ r7);
    }

    private void addRoundKey32(int[] q, int[] sk) {
        q[0] = q[0] ^ sk[0];
        q[1] = q[1] ^ sk[1];
        q[2] = q[2] ^ sk[2];
        q[3] = q[3] ^ sk[3];
        q[4] = q[4] ^ sk[4];
        q[5] = q[5] ^ sk[5];
        q[6] = q[6] ^ sk[6];
        q[7] = q[7] ^ sk[7];
    }

    private int rotr16(int x) {
        return x << 16 | x >>> 16;
    }

    private void brAesCt64Ortho(long[] q) {
        this.Swapn(q, 1, 0, 1);
        this.Swapn(q, 1, 2, 3);
        this.Swapn(q, 1, 4, 5);
        this.Swapn(q, 1, 6, 7);
        this.Swapn(q, 2, 0, 2);
        this.Swapn(q, 2, 1, 3);
        this.Swapn(q, 2, 4, 6);
        this.Swapn(q, 2, 5, 7);
        this.Swapn(q, 4, 0, 4);
        this.Swapn(q, 4, 1, 5);
        this.Swapn(q, 4, 2, 6);
        this.Swapn(q, 4, 3, 7);
    }

    private void brAesCtOrtho(int[] q) {
        this.Swapn32(q, 1, 0, 1);
        this.Swapn32(q, 1, 2, 3);
        this.Swapn32(q, 1, 4, 5);
        this.Swapn32(q, 1, 6, 7);
        this.Swapn32(q, 2, 0, 2);
        this.Swapn32(q, 2, 1, 3);
        this.Swapn32(q, 2, 4, 6);
        this.Swapn32(q, 2, 5, 7);
        this.Swapn32(q, 4, 0, 4);
        this.Swapn32(q, 4, 1, 5);
        this.Swapn32(q, 4, 2, 6);
        this.Swapn32(q, 4, 3, 7);
    }

    private void Swapn32(int[] q, int s, int pos1, int pos2) {
        int cl = 0;
        int ch = 0;
        switch (s) {
            case 1: {
                cl = 0x55555555;
                ch = -1431655766;
                break;
            }
            case 2: {
                cl = 0x33333333;
                ch = -858993460;
                break;
            }
            case 4: {
                cl = 0xF0F0F0F;
                ch = -252645136;
            }
        }
        int a = q[pos1];
        int b = q[pos2];
        q[pos1] = a & cl | (b & cl) << s;
        q[pos2] = (a & ch) >>> s | b & ch;
    }

    private void Swapn(long[] q, int s, int pos1, int pos2) {
        long cl = 0L;
        long ch = 0L;
        switch (s) {
            case 1: {
                cl = 0x5555555555555555L;
                ch = -6148914691236517206L;
                break;
            }
            case 2: {
                cl = 0x3333333333333333L;
                ch = -3689348814741910324L;
                break;
            }
            case 4: {
                cl = 0xF0F0F0F0F0F0F0FL;
                ch = -1085102592571150096L;
                break;
            }
            default: {
                return;
            }
        }
        long a = q[pos1];
        long b = q[pos2];
        q[pos1] = a & cl | (b & cl) << s;
        q[pos2] = (a & ch) >>> s | b & ch;
    }

    private void brAesCt64BitsliceSbox(long[] q) {
        long x0 = q[7];
        long x1 = q[6];
        long x2 = q[5];
        long x3 = q[4];
        long x4 = q[3];
        long x5 = q[2];
        long x6 = q[1];
        long x7 = q[0];
        long y14 = x3 ^ x5;
        long y13 = x0 ^ x6;
        long y9 = x0 ^ x3;
        long y8 = x0 ^ x5;
        long t0 = x1 ^ x2;
        long y1 = t0 ^ x7;
        long y4 = y1 ^ x3;
        long y12 = y13 ^ y14;
        long y2 = y1 ^ x0;
        long y5 = y1 ^ x6;
        long y3 = y5 ^ y8;
        long t1 = x4 ^ y12;
        long y15 = t1 ^ x5;
        long y20 = t1 ^ x1;
        long y6 = y15 ^ x7;
        long y10 = y15 ^ t0;
        long y11 = y20 ^ y9;
        long y7 = x7 ^ y11;
        long y17 = y10 ^ y11;
        long y19 = y10 ^ y8;
        long y16 = t0 ^ y11;
        long y21 = y13 ^ y16;
        long y18 = x0 ^ y16;
        long t2 = y12 & y15;
        long t3 = y3 & y6;
        long t4 = t3 ^ t2;
        long t5 = y4 & x7;
        long t6 = t5 ^ t2;
        long t7 = y13 & y16;
        long t8 = y5 & y1;
        long t9 = t8 ^ t7;
        long t10 = y2 & y7;
        long t11 = t10 ^ t7;
        long t12 = y9 & y11;
        long t13 = y14 & y17;
        long t14 = t13 ^ t12;
        long t15 = y8 & y10;
        long t16 = t15 ^ t12;
        long t17 = t4 ^ t14;
        long t18 = t6 ^ t16;
        long t19 = t9 ^ t14;
        long t20 = t11 ^ t16;
        long t21 = t17 ^ y20;
        long t22 = t18 ^ y19;
        long t23 = t19 ^ y21;
        long t24 = t20 ^ y18;
        long t25 = t21 ^ t22;
        long t26 = t21 & t23;
        long t27 = t24 ^ t26;
        long t28 = t25 & t27;
        long t29 = t28 ^ t22;
        long t30 = t23 ^ t24;
        long t31 = t22 ^ t26;
        long t32 = t31 & t30;
        long t33 = t32 ^ t24;
        long t34 = t23 ^ t33;
        long t35 = t27 ^ t33;
        long t36 = t24 & t35;
        long t37 = t36 ^ t34;
        long t38 = t27 ^ t36;
        long t39 = t29 & t38;
        long t40 = t25 ^ t39;
        long t41 = t40 ^ t37;
        long t42 = t29 ^ t33;
        long t43 = t29 ^ t40;
        long t44 = t33 ^ t37;
        long t45 = t42 ^ t41;
        long z0 = t44 & y15;
        long z1 = t37 & y6;
        long z2 = t33 & x7;
        long z3 = t43 & y16;
        long z4 = t40 & y1;
        long z5 = t29 & y7;
        long z6 = t42 & y11;
        long z7 = t45 & y17;
        long z8 = t41 & y10;
        long z9 = t44 & y12;
        long z10 = t37 & y3;
        long z11 = t33 & y4;
        long z12 = t43 & y13;
        long z13 = t40 & y5;
        long z14 = t29 & y2;
        long z15 = t42 & y9;
        long z16 = t45 & y14;
        long z17 = t41 & y8;
        long t46 = z15 ^ z16;
        long t47 = z10 ^ z11;
        long t48 = z5 ^ z13;
        long t49 = z9 ^ z10;
        long t50 = z2 ^ z12;
        long t51 = z2 ^ z5;
        long t52 = z7 ^ z8;
        long t53 = z0 ^ z3;
        long t54 = z6 ^ z7;
        long t55 = z16 ^ z17;
        long t56 = z12 ^ t48;
        long t57 = t50 ^ t53;
        long t58 = z4 ^ t46;
        long t59 = z3 ^ t54;
        long t60 = t46 ^ t57;
        long t61 = z14 ^ t57;
        long t62 = t52 ^ t58;
        long t63 = t49 ^ t58;
        long t64 = z4 ^ t59;
        long t65 = t61 ^ t62;
        long t66 = z1 ^ t63;
        long s0 = t59 ^ t63;
        long s6 = t56 ^ (t62 ^ 0xFFFFFFFFFFFFFFFFL);
        long s7 = t48 ^ (t60 ^ 0xFFFFFFFFFFFFFFFFL);
        long t67 = t64 ^ t65;
        long s3 = t53 ^ t66;
        long s4 = t51 ^ t66;
        long s5 = t47 ^ t65;
        long s1 = t64 ^ (s3 ^ 0xFFFFFFFFFFFFFFFFL);
        long s2 = t55 ^ (t67 ^ 0xFFFFFFFFFFFFFFFFL);
        q[7] = s0;
        q[6] = s1;
        q[5] = s2;
        q[4] = s3;
        q[3] = s4;
        q[2] = s5;
        q[1] = s6;
        q[0] = s7;
    }

    private void shiftRows(long[] q) {
        for (int i = 0; i < q.length; ++i) {
            long x = q[i];
            q[i] = x & 0xFFFFL | (x & 0xFFF00000L) >>> 4 | (x & 0xF0000L) << 12 | (x & 0xFF0000000000L) >>> 8 | (x & 0xFF00000000L) << 8 | (x & 0xF000000000000000L) >>> 12 | (x & 0xFFF000000000000L) << 4;
        }
    }

    private void mixColumns(long[] q) {
        long q0 = q[0];
        long q1 = q[1];
        long q2 = q[2];
        long q3 = q[3];
        long q4 = q[4];
        long q5 = q[5];
        long q6 = q[6];
        long q7 = q[7];
        long r0 = q0 >>> 16 | q0 << 48;
        long r1 = q1 >>> 16 | q1 << 48;
        long r2 = q2 >>> 16 | q2 << 48;
        long r3 = q3 >>> 16 | q3 << 48;
        long r4 = q4 >>> 16 | q4 << 48;
        long r5 = q5 >>> 16 | q5 << 48;
        long r6 = q6 >>> 16 | q6 << 48;
        long r7 = q7 >>> 16 | q7 << 48;
        q[0] = q7 ^ r7 ^ r0 ^ this.rotr32(q0 ^ r0);
        q[1] = q0 ^ r0 ^ q7 ^ r7 ^ r1 ^ this.rotr32(q1 ^ r1);
        q[2] = q1 ^ r1 ^ r2 ^ this.rotr32(q2 ^ r2);
        q[3] = q2 ^ r2 ^ q7 ^ r7 ^ r3 ^ this.rotr32(q3 ^ r3);
        q[4] = q3 ^ r3 ^ q7 ^ r7 ^ r4 ^ this.rotr32(q4 ^ r4);
        q[5] = q4 ^ r4 ^ r5 ^ this.rotr32(q5 ^ r5);
        q[6] = q5 ^ r5 ^ r6 ^ this.rotr32(q6 ^ r6);
        q[7] = q6 ^ r6 ^ r7 ^ this.rotr32(q7 ^ r7);
    }

    private long rotr32(long x) {
        return x << 32 | x >>> 32;
    }

    private void addRoundKey(long[] q, long[] sk) {
        q[0] = q[0] ^ sk[0];
        q[1] = q[1] ^ sk[1];
        q[2] = q[2] ^ sk[2];
        q[3] = q[3] ^ sk[3];
        q[4] = q[4] ^ sk[4];
        q[5] = q[5] ^ sk[5];
        q[6] = q[6] ^ sk[6];
        q[7] = q[7] ^ sk[7];
    }

    private void brAesCt64InterleaveOut(int[] w, long[] q, int pos) {
        long x0 = q[pos] & 0xFF00FF00FF00FFL;
        long x1 = q[pos + 4] & 0xFF00FF00FF00FFL;
        long x2 = q[pos] >>> 8 & 0xFF00FF00FF00FFL;
        long x3 = q[pos + 4] >>> 8 & 0xFF00FF00FF00FFL;
        x0 |= x0 >>> 8;
        x1 |= x1 >>> 8;
        x2 |= x2 >>> 8;
        x3 |= x3 >>> 8;
        w[pos <<= 2] = (int)((x0 &= 0xFFFF0000FFFFL) | x0 >>> 16);
        w[pos + 1] = (int)((x1 &= 0xFFFF0000FFFFL) | x1 >>> 16);
        w[pos + 2] = (int)((x2 &= 0xFFFF0000FFFFL) | x2 >>> 16);
        w[pos + 3] = (int)((x3 &= 0xFFFF0000FFFFL) | x3 >>> 16);
    }

    protected static void xor(byte[] x, int xOff, byte[] y, int yOff, byte[] z, int zOff, int zLen) {
        for (int i = 0; i < zLen; ++i) {
            z[zOff + i] = (byte)(x[xOff + i] ^ y[yOff + i]);
        }
    }
}

