/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntruprime;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimeParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ntruprime.NTRULPRimePublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntruprime.BCNTRULPRimePrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.ntruprime.BCNTRULPRimePublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.NTRULPRimeParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class NTRULPRimeKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    NTRULPRimeKeyGenerationParameters param;
    NTRULPRimeKeyPairGenerator engine = new NTRULPRimeKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public NTRULPRimeKeyPairGeneratorSpi() {
        super("NTRULPRime");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        String name = NTRULPRimeKeyPairGeneratorSpi.getNameFromParams(params);
        if (name == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + params);
        }
        this.param = new NTRULPRimeKeyGenerationParameters(random, (NTRULPRimeParameters)parameters.get(name));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec paramSpec) {
        if (paramSpec instanceof NTRULPRimeParameterSpec) {
            NTRULPRimeParameterSpec frodoParams = (NTRULPRimeParameterSpec)paramSpec;
            return frodoParams.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(paramSpec));
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new NTRULPRimeKeyGenerationParameters(this.random, NTRULPRimeParameters.ntrulpr953);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        NTRULPRimePublicKeyParameters pub = (NTRULPRimePublicKeyParameters)pair.getPublic();
        NTRULPRimePrivateKeyParameters priv = (NTRULPRimePrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCNTRULPRimePublicKey(pub), new BCNTRULPRimePrivateKey(priv));
    }

    static {
        parameters.put(NTRULPRimeParameterSpec.ntrulpr653.getName(), NTRULPRimeParameters.ntrulpr653);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr761.getName(), NTRULPRimeParameters.ntrulpr761);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr857.getName(), NTRULPRimeParameters.ntrulpr857);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr953.getName(), NTRULPRimeParameters.ntrulpr953);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr1013.getName(), NTRULPRimeParameters.ntrulpr1013);
        parameters.put(NTRULPRimeParameterSpec.ntrulpr1277.getName(), NTRULPRimeParameters.ntrulpr1277);
    }
}

