/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpValidationKey
extends ACryptographyKey<PGPPublicKey>
implements IPublicCryptographyKey<PGPPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpValidationKey.class);
    private PGPPublicKey key;

    public PgpValidationKey(PGPPublicKey key) {
        super(EKeyPurpose.VALIDATION, ECryptographyType.PGP);
        this.key = key;
        if (key == null) {
            log.warn("Public key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public PgpValidationKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public PgpValidationKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.VALIDATION, ECryptographyType.PGP);
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Override
    public PGPPublicKey getKey() {
        return this.key;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("PGP Public Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Validation Key ID: ");
        builder.append(PgpUtil.getPrettyId(this.getKey()));
        return builder.toString();
    }
}

