/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.util;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.security.auth.Destroyable;
import net.savignano.cryptography.util.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreContentFetcher
implements Destroyable {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreContentFetcher.class);
    private KeyStore keyStore;
    private char[] password;

    public KeyStoreContentFetcher(KeyStore keyStore) {
        this.keyStore = keyStore;
        if (keyStore == null) {
            throw new IllegalArgumentException("Key Store must not be null.");
        }
    }

    public void keyPassword(char[] password) {
        this.password = password == null ? null : Arrays.copyOf(password, password.length);
    }

    public Optional<X509Certificate> getCertFor(Predicate<X509Certificate> predicate) throws KeyStoreException {
        if (predicate == null) {
            return Optional.empty();
        }
        Set<X509Certificate> certs = this.getCertsFor(predicate, true);
        return certs.isEmpty() ? Optional.empty() : Optional.of(certs.iterator().next());
    }

    public Set<X509Certificate> getCertsFor(Predicate<X509Certificate> predicate) throws KeyStoreException {
        if (predicate == null) {
            return Collections.emptySet();
        }
        return this.getCertsFor(predicate, false);
    }

    public Optional<PrivateKey> getPrivateKeyFor(Predicate<X509Certificate> predicate) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (predicate == null) {
            return Optional.empty();
        }
        Set<Map.Entry<X509Certificate, PrivateKey>> result = this.getEntriesFor(predicate, true);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        Map.Entry<X509Certificate, PrivateKey> entry = result.iterator().next();
        return Optional.ofNullable(entry.getValue());
    }

    public Set<PrivateKey> getPrivateKeysFor(Predicate<X509Certificate> predicate) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (predicate == null) {
            return Collections.emptySet();
        }
        return this.getEntriesFor(predicate, false).stream().map(e -> (PrivateKey)e.getValue()).filter(pk -> pk != null).collect(Collectors.toSet());
    }

    public Optional<Map.Entry<X509Certificate, PrivateKey>> getEntryFor(Predicate<X509Certificate> predicate) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (predicate == null) {
            return Optional.empty();
        }
        Set<Map.Entry<X509Certificate, PrivateKey>> result = this.getEntriesFor(predicate, true);
        return result.isEmpty() ? Optional.empty() : Optional.of(result.iterator().next());
    }

    public Set<Map.Entry<X509Certificate, PrivateKey>> getEntriesFor(Predicate<X509Certificate> predicate) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (predicate == null) {
            return Collections.emptySet();
        }
        return this.getEntriesFor(predicate, false);
    }

    private Set<X509Certificate> getCertsFor(Predicate<X509Certificate> predicate, boolean stopEarly) throws KeyStoreException {
        log.trace("Checking key store with {} entries.", (Object)this.keyStore.size());
        HashSet<X509Certificate> result = new HashSet<X509Certificate>(stopEarly ? 1 : 5);
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            log.trace("Checking alias: {}", (Object)alias);
            X509Certificate cert = this.getCertForAlias(alias);
            if (cert == null || !predicate.test(cert)) continue;
            result.add(cert);
            if (!stopEarly) continue;
            break;
        }
        return result;
    }

    private Set<Map.Entry<X509Certificate, PrivateKey>> getEntriesFor(Predicate<X509Certificate> predicate, boolean stopEarly) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        log.trace("Checking key store with {} entries.", (Object)this.keyStore.size());
        HashSet<Map.Entry<X509Certificate, PrivateKey>> result = new HashSet<Map.Entry<X509Certificate, PrivateKey>>(stopEarly ? 1 : 5);
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!this.keyStore.isKeyEntry(alias)) continue;
            log.trace("Checking alias: {}", (Object)alias);
            X509Certificate cert = this.getCertForAlias(alias);
            if (cert == null || !predicate.test(cert)) continue;
            Key key = this.keyStore.getKey(alias, this.password);
            if (!(key instanceof PrivateKey)) {
                log.warn("Private key for alias \"{}\" is not the expected type. Encountered class: {}", (Object)alias, key == null ? null : key.getClass());
                continue;
            }
            result.add(new AbstractMap.SimpleEntry<X509Certificate, PrivateKey>(cert, (PrivateKey)key));
            if (!stopEarly) continue;
            break;
        }
        return result;
    }

    private X509Certificate getCertForAlias(String alias) throws KeyStoreException {
        Certificate cert = this.keyStore.getCertificate(alias);
        if (cert != null && !(cert instanceof X509Certificate)) {
            log.warn("Certificate found for alias \"{}\" is not a X509Certificate. It cannot be used. Found certificate: {}", (Object)alias, (Object)cert);
            return null;
        }
        return (X509Certificate)cert;
    }

    @Override
    public void destroy() {
        this.keyStore = null;
        SecurityUtil.clearPassword(this.password);
    }

    @Override
    public boolean isDestroyed() {
        return this.keyStore == null;
    }
}

