/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.templates.handler.impl.wrapper;

import jakarta.servlet.http.HttpServletRequest;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.templates.handler.IInputHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.AAppPropValueHandler;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringInputToLongWrapperHandler
extends AAppPropValueHandler<String>
implements IInputHandler {
    private static final Logger log = LoggerFactory.getLogger(StringInputToLongWrapperHandler.class);

    public StringInputToLongWrapperHandler(String id, ISnotifyAppProperties appProps, EProperty prop) {
        super(id, appProps, prop);
        if (!Long.class.equals(prop.getType())) {
            throw new IllegalArgumentException("Only a 'Long' property is allowed.");
        }
    }

    @Override
    public void read() {
        Long number = this.getAppProps().getLong(this.getProp());
        this.setValue(number != null ? number.toString() : null);
    }

    @Override
    public void store() {
        Long asLong = this.asLong();
        if (asLong != null || this.getValue() == null) {
            this.getAppProps().setLong(this.getProp(), asLong);
        }
    }

    @Override
    public void receive(HttpServletRequest request) {
        String input = StringUtils.stripToNull((String)request.getParameter(this.getId()));
        if (input != null) {
            this.setValue(input);
        } else {
            Long defVal = (Long)this.getProp().getDefaultValue();
            this.setValue(defVal != null ? defVal.toString() : null);
        }
    }

    @Override
    public String getInput() {
        String input = (String)this.getValue();
        return input != null ? input : "";
    }

    public Long asLong() {
        String value = (String)this.getValue();
        Long asLong = null;
        if (value != null) {
            try {
                asLong = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                log.warn("Could not convert value '{}' into a number for field with ID: {}", (Object)value, (Object)this.getId());
            }
        }
        return asLong;
    }
}

