/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.common;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserPreferences;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.opensymphony.module.propertyset.PropertyException;
import net.savignano.snotify.atlassian.common.properties.ASnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.confluence.common.ConfluenceUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SnotifyUserProperties
extends ASnotifyUserProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserProperties.class);
    @Autowired
    @ComponentImport
    private UserAccessor accessor;

    @Override
    protected String get(String key, IUser<?> user) throws Exception {
        return this.getPrefs(user).getString(key).orElse(null);
    }

    @Override
    protected void set(String key, String value, IUser<?> user) throws Exception {
        this.getPrefs(user).setString(key, value);
    }

    @Override
    protected void remove(String key, IUser<?> user) throws Exception {
        this.getPrefs(user).remove(key);
    }

    private UserPreferences getPrefs(IUser<?> user) {
        if (user == null) {
            throw new PropertyException("Can't get user preferences for 'null' user.");
        }
        if (!(user instanceof ConfluenceUser)) {
            throw new PropertyException("User is not a ConfluenceUser. Found instead: " + String.valueOf(user));
        }
        return this.getAccessor().getUserPreferences(((ConfluenceUser)user).getAsConfluenceUser());
    }

    private UserAccessor getAccessor() {
        if (this.accessor == null) {
            log.trace("Injection of UserAccessor failed. Loading manually.");
            this.accessor = (UserAccessor)ComponentLocator.getComponent(UserAccessor.class);
        }
        return this.accessor;
    }
}

