/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui;

import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.component.ComponentLocator;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.gui.APluginListener;
import net.savignano.snotify.atlassian.gui.AtlassianMailerVersion;
import net.savignano.snotify.confluence.common.ConfluenceConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ConfluencePluginListener
extends APluginListener {
    private static final Logger log = LoggerFactory.getLogger(ConfluencePluginListener.class);

    @Override
    protected void setMailerVersion() {
        SMTPMailServer server = MailFactory.getServerManager().getDefaultSMTPMailServer();
        if (server == null) {
            this.getAppProps().setString(EProperty.MAILER_VERSION, null);
            log.warn("Cannot check if correct mailer library for S/Notify is installed. Please configure an outgoing SMTP mail server, so S/Notify can automatically check if the GUI plugin and Mailer library are compatible with each other.");
            return;
        }
        AtlassianMailerVersion mailerVersion = new AtlassianMailerVersion(server, this.getAppProps());
        mailerVersion.setAtlassianUrl(((GlobalSettingsManager)ComponentLocator.getComponent(GlobalSettingsManager.class)).getGlobalSettings().getBaseUrl());
        mailerVersion.setProductInfo(ConfluenceConstants.PRODUCT_INFORMATION);
        mailerVersion.getVersion();
    }

    @Override
    protected void createCache() {
    }

    @Override
    protected void destroyCache() {
    }
}

