/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1RelativeOID;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1UniversalType;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.OIDTokenizer;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class ASN1ObjectIdentifier
extends ASN1Primitive {
    static final ASN1UniversalType TYPE = new ASN1UniversalType(ASN1ObjectIdentifier.class, 6){

        @Override
        ASN1Primitive fromImplicitPrimitive(DEROctetString octetString) {
            return ASN1ObjectIdentifier.createPrimitive(octetString.getOctets(), false);
        }
    };
    private static final int MAX_CONTENTS_LENGTH = 4096;
    private static final int MAX_IDENTIFIER_LENGTH = 16385;
    private static final long LONG_LIMIT = 0xFFFFFFFFFFFF80L;
    private static final ConcurrentMap<OidHandle, ASN1ObjectIdentifier> pool = new ConcurrentHashMap<OidHandle, ASN1ObjectIdentifier>();
    private final byte[] contents;
    private String identifier;

    public static ASN1ObjectIdentifier fromContents(byte[] contents) {
        if (contents == null) {
            throw new NullPointerException("'contents' cannot be null");
        }
        return ASN1ObjectIdentifier.createPrimitive(contents, true);
    }

    public static ASN1ObjectIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (primitive instanceof ASN1ObjectIdentifier) {
                return (ASN1ObjectIdentifier)primitive;
            }
        } else if (obj instanceof byte[]) {
            try {
                return (ASN1ObjectIdentifier)TYPE.fromByteArray((byte[])obj);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct object identifier from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        ASN1Primitive base;
        if (!explicit && !taggedObject.isParsed() && taggedObject.hasContextTag() && !((base = taggedObject.getBaseObject().toASN1Primitive()) instanceof ASN1ObjectIdentifier)) {
            return ASN1ObjectIdentifier.fromContents(ASN1OctetString.getInstance(base).getOctets());
        }
        return (ASN1ObjectIdentifier)TYPE.getContextInstance(taggedObject, explicit);
    }

    public static ASN1ObjectIdentifier tryFromID(String identifier) {
        byte[] contents;
        if (identifier == null) {
            throw new NullPointerException("'identifier' cannot be null");
        }
        if (identifier.length() <= 16385 && ASN1ObjectIdentifier.isValidIdentifier(identifier) && (contents = ASN1ObjectIdentifier.parseIdentifier(identifier)).length <= 4096) {
            return new ASN1ObjectIdentifier(contents, identifier);
        }
        return null;
    }

    public ASN1ObjectIdentifier(String identifier) {
        ASN1ObjectIdentifier.checkIdentifier(identifier);
        byte[] contents = ASN1ObjectIdentifier.parseIdentifier(identifier);
        ASN1ObjectIdentifier.checkContentsLength(contents.length);
        this.contents = contents;
        this.identifier = identifier;
    }

    private ASN1ObjectIdentifier(byte[] contents, String identifier) {
        this.contents = contents;
        this.identifier = identifier;
    }

    public ASN1ObjectIdentifier branch(String branchID) {
        ASN1RelativeOID.checkIdentifier(branchID);
        byte[] branchContents = ASN1RelativeOID.parseIdentifier(branchID);
        ASN1ObjectIdentifier.checkContentsLength(this.contents.length + branchContents.length);
        byte[] contents = Arrays.concatenate(this.contents, branchContents);
        String identifier = this.getId() + "." + branchID;
        return new ASN1ObjectIdentifier(contents, identifier);
    }

    public synchronized String getId() {
        if (this.identifier == null) {
            this.identifier = ASN1ObjectIdentifier.parseContents(this.contents);
        }
        return this.identifier;
    }

    public boolean on(ASN1ObjectIdentifier stem) {
        byte[] contents = this.contents;
        byte[] stemContents = stem.contents;
        int stemLength = stemContents.length;
        return contents.length > stemLength && Arrays.areEqual(contents, 0, stemLength, stemContents, 0, stemLength);
    }

    @Override
    boolean encodeConstructed() {
        return false;
    }

    @Override
    int encodedLength(boolean withTag) {
        return ASN1OutputStream.getLengthOfEncodingDL(withTag, this.contents.length);
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        out.writeEncodingDL(withTag, 6, this.contents);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    @Override
    boolean asn1Equals(ASN1Primitive other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ASN1ObjectIdentifier)) {
            return false;
        }
        ASN1ObjectIdentifier that = (ASN1ObjectIdentifier)other;
        return Arrays.areEqual(this.contents, that.contents);
    }

    public String toString() {
        return this.getId();
    }

    static void checkContentsLength(int contentsLength) {
        if (contentsLength > 4096) {
            throw new IllegalArgumentException("exceeded OID contents length limit");
        }
    }

    static void checkIdentifier(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("'identifier' cannot be null");
        }
        if (identifier.length() > 16385) {
            throw new IllegalArgumentException("exceeded OID contents length limit");
        }
        if (!ASN1ObjectIdentifier.isValidIdentifier(identifier)) {
            throw new IllegalArgumentException("string " + identifier + " not a valid OID");
        }
    }

    static ASN1ObjectIdentifier createPrimitive(byte[] contents, boolean clone) {
        ASN1ObjectIdentifier.checkContentsLength(contents.length);
        OidHandle hdl = new OidHandle(contents);
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)pool.get(hdl);
        if (oid != null) {
            return oid;
        }
        if (!ASN1RelativeOID.isValidContents(contents)) {
            throw new IllegalArgumentException("invalid OID contents");
        }
        return new ASN1ObjectIdentifier(clone ? Arrays.clone(contents) : contents, null);
    }

    private static boolean isValidIdentifier(String identifier) {
        if (identifier.length() < 3 || identifier.charAt(1) != '.') {
            return false;
        }
        char first = identifier.charAt(0);
        if (first < '0' || first > '2') {
            return false;
        }
        if (!ASN1RelativeOID.isValidIdentifier(identifier, 2)) {
            return false;
        }
        if (first == '2') {
            return true;
        }
        if (identifier.length() == 3 || identifier.charAt(3) == '.') {
            return true;
        }
        if (identifier.length() == 4 || identifier.charAt(4) == '.') {
            return identifier.charAt(2) < '4';
        }
        return false;
    }

    private static String parseContents(byte[] contents) {
        StringBuilder objId = new StringBuilder();
        long value = 0L;
        BigInteger bigValue = null;
        boolean first = true;
        for (int i = 0; i != contents.length; ++i) {
            int b = contents[i] & 0xFF;
            if (value <= 0xFFFFFFFFFFFF80L) {
                value += (long)(b & 0x7F);
                if ((b & 0x80) == 0) {
                    if (first) {
                        if (value < 40L) {
                            objId.append('0');
                        } else if (value < 80L) {
                            objId.append('1');
                            value -= 40L;
                        } else {
                            objId.append('2');
                            value -= 80L;
                        }
                        first = false;
                    }
                    objId.append('.');
                    objId.append(value);
                    value = 0L;
                    continue;
                }
                value <<= 7;
                continue;
            }
            if (bigValue == null) {
                bigValue = BigInteger.valueOf(value);
            }
            bigValue = bigValue.or(BigInteger.valueOf(b & 0x7F));
            if ((b & 0x80) == 0) {
                if (first) {
                    objId.append('2');
                    bigValue = bigValue.subtract(BigInteger.valueOf(80L));
                    first = false;
                }
                objId.append('.');
                objId.append(bigValue);
                bigValue = null;
                value = 0L;
                continue;
            }
            bigValue = bigValue.shiftLeft(7);
        }
        return objId.toString();
    }

    private static byte[] parseIdentifier(String identifier) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        OIDTokenizer tok = new OIDTokenizer(identifier);
        int first = Integer.parseInt(tok.nextToken()) * 40;
        String secondToken = tok.nextToken();
        if (secondToken.length() <= 18) {
            ASN1RelativeOID.writeField(bOut, (long)first + Long.parseLong(secondToken));
        } else {
            ASN1RelativeOID.writeField(bOut, new BigInteger(secondToken).add(BigInteger.valueOf(first)));
        }
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.length() <= 18) {
                ASN1RelativeOID.writeField(bOut, Long.parseLong(token));
                continue;
            }
            ASN1RelativeOID.writeField(bOut, new BigInteger(token));
        }
        return bOut.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASN1ObjectIdentifier intern() {
        OidHandle hdl = new OidHandle(this.contents);
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)pool.get(hdl);
        if (oid == null) {
            ConcurrentMap<OidHandle, ASN1ObjectIdentifier> concurrentMap = pool;
            synchronized (concurrentMap) {
                if (!pool.containsKey(hdl)) {
                    pool.put(hdl, this);
                    return this;
                }
                return (ASN1ObjectIdentifier)pool.get(hdl);
            }
        }
        return oid;
    }

    static class OidHandle {
        private final int key;
        private final byte[] contents;

        OidHandle(byte[] contents) {
            this.key = Arrays.hashCode(contents);
            this.contents = contents;
        }

        public int hashCode() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (o instanceof OidHandle) {
                return Arrays.areEqual(this.contents, ((OidHandle)o).contents);
            }
            return false;
        }
    }
}

