/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGObject;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.MPInteger;

public class RSAPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger n;
    MPInteger e;

    public RSAPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.n = new MPInteger(in);
        this.e = new MPInteger(in);
    }

    public RSAPublicBCPGKey(BigInteger n, BigInteger e) {
        this.n = new MPInteger(n);
        this.e = new MPInteger(e);
    }

    public BigInteger getPublicExponent() {
        return this.e.getValue();
    }

    public BigInteger getModulus() {
        return this.n.getValue();
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.n);
        out.writeObject(this.e);
    }
}

