/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.EcdsaP256Signature;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.EcdsaP384Signature;

public class Signature
extends ASN1Object
implements ASN1Choice {
    public static final int ecdsaNistP256Signature = 0;
    public static final int ecdsaBrainpoolP256r1Signature = 1;
    public static final int ecdsaBrainpoolP384r1Signature = 2;
    private final int choice;
    private final ASN1Encodable signature;

    public Signature(int choice, ASN1Encodable value) {
        this.choice = choice;
        this.signature = value;
    }

    public static Signature ecdsaNistP256Signature(EcdsaP256Signature v) {
        return new Signature(0, v);
    }

    public static Signature ecdsaBrainpoolP256r1Signature(EcdsaP256Signature v) {
        return new Signature(1, v);
    }

    public static Signature ecdsaBrainpoolP384r1Signature(EcdsaP384Signature v) {
        return new Signature(2, v);
    }

    private Signature(ASN1TaggedObject ato) {
        this.choice = ato.getTagNo();
        switch (this.choice) {
            case 0: 
            case 1: {
                this.signature = EcdsaP256Signature.getInstance(ato.getExplicitBaseObject());
                break;
            }
            case 2: {
                this.signature = EcdsaP384Signature.getInstance(ato.getExplicitBaseObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid choice value " + ato.getTagNo());
            }
        }
    }

    public static Signature getInstance(Object objectAt) {
        if (objectAt instanceof Signature) {
            return (Signature)objectAt;
        }
        if (objectAt != null) {
            return new Signature(ASN1TaggedObject.getInstance(objectAt, 128));
        }
        return null;
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getSignature() {
        return this.signature;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.signature);
    }
}

