/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADEncDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSymmetricKeyEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;

public class PGPSessionKeyEncryptedData
extends PGPSymmetricKeyEncryptedData {
    PGPSessionKeyEncryptedData(InputStreamPacket encData) {
        super(encData);
    }

    @Override
    public int getAlgorithm() {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
            return aeadData.getAlgorithm();
        }
        return -1;
    }

    @Override
    public int getVersion() {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
            return aeadData.getVersion();
        }
        if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket symIntData = (SymmetricEncIntegrityPacket)this.encData;
            return symIntData.getVersion();
        }
        return -1;
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        this.encStream = this.createDecryptionStream(dataDecryptorFactory, dataDecryptorFactory.getSessionKey());
        return this.encStream;
    }
}

