/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADEncDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPDataValidationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;

public class PGPSymmetricKeyEncryptedData
extends PGPEncryptedData {
    protected PGPSymmetricKeyEncryptedData(InputStreamPacket encData) {
        super(encData);
    }

    protected InputStream createDecryptionStream(PGPDataDecryptorFactory dataDecryptorFactory, PGPSessionKey sessionKey) throws PGPException {
        if (this.encData instanceof AEADEncDataPacket) {
            AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
            if (aeadData.getAlgorithm() != sessionKey.getAlgorithm()) {
                throw new PGPException("session key and AEAD algorithm mismatch");
            }
            PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(aeadData, sessionKey);
            BCPGInputStream encIn = this.encData.getInputStream();
            return new BCPGInputStream(dataDecryptor.getInputStream(encIn));
        }
        if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket seipd = (SymmetricEncIntegrityPacket)this.encData;
            if (seipd.getVersion() == 1) {
                PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(true, sessionKey.getAlgorithm(), sessionKey.getKey());
                return this.getDataStream(true, dataDecryptor);
            }
            if (seipd.getVersion() == 2) {
                PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(seipd, sessionKey);
                return new BCPGInputStream(dataDecryptor.getInputStream(this.encData.getInputStream()));
            }
            throw new UnsupportedPacketVersionException("Unsupported SEIPD packet version: " + seipd.getVersion());
        }
        PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(false, sessionKey.getAlgorithm(), sessionKey.getKey());
        return this.getDataStream(false, dataDecryptor);
    }

    private InputStream getDataStream(boolean withIntegrityPacket, PGPDataDecryptor dataDecryptor) throws PGPException {
        try {
            BCPGInputStream encIn = this.encData.getInputStream();
            encIn.mark(dataDecryptor.getBlockSize() + 2);
            if (this.processSymmetricEncIntegrityPacketDataStream(withIntegrityPacket, dataDecryptor, encIn)) {
                encIn.reset();
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }
}

